/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.internal.performance.LatenciometerKt;
import com.intellij.internal.performance.LatencyDistributionRecord;
import com.intellij.internal.performance.LatencyRecord;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010 \u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/internal/performance/TypingLatencyReportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "threadDumps", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "currentThreadDump", "", "nextThreadDumpButton", "Ljavax/swing/JButton;", "prevThreadDumpButton", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createReportTree", "Lcom/intellij/ui/components/JBScrollPane;", "createThreadDumpBrowser", "formatHeader", "htmlStyle", "", "formatLatency", "action", "latencyRecord", "Lcom/intellij/internal/performance/LatencyRecord;", "details", "formatReportAsText", "updateCurrentThreadDump", "", "ExportToFileAction", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nTypingLatencyReportDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingLatencyReportDialog.kt\ncom/intellij/internal/performance/TypingLatencyReportDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,207:1\n1045#2:208\n1054#2:209\n1045#2:218\n1054#2:219\n125#3:210\n152#3,3:211\n125#3:214\n152#3,3:215\n*S KotlinDebug\n*F\n+ 1 TypingLatencyReportDialog.kt\ncom/intellij/internal/performance/TypingLatencyReportDialog\n*L\n86#1:208\n89#1:209\n176#1:218\n179#1:219\n128#1:210\n128#1:211,3\n131#1:214\n131#1:215,3\n*E\n"})
public final class TypingLatencyReportDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final List<String> threadDumps;
    private int currentThreadDump;
    private ConsoleView consoleView;
    private JButton prevThreadDumpButton;
    private JButton nextThreadDumpButton;

    public TypingLatencyReportDialog(@NotNull Project project2, @NotNull List<String> threadDumps) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(threadDumps, (String)"threadDumps");
        super(project2);
        this.project = project2;
        this.threadDumps = threadDumps;
        this.init();
        this.setTitle("Typing Latency Report");
    }

    public /* synthetic */ TypingLatencyReportDialog(Project project2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(project2, list2);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBSplitter jBSplitter;
        JComponent panel2;
        JBScrollPane jbScrollPane = this.createReportTree();
        if (!LatenciometerKt.getLatencyRecorderProperties().isEmpty()) {
            JBSplitter jBSplitter2;
            JLabel header = new JLabel(this.formatHeader(true));
            JBSplitter $this$createCenterPanel_u24lambda_u240 = jBSplitter2 = new JBSplitter(true);
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u240.setResizeEnabled(false);
            this.setResizable(false);
            $this$createCenterPanel_u24lambda_u240.setProportion(0.01f);
            $this$createCenterPanel_u24lambda_u240.setFirstComponent((JComponent)header);
            $this$createCenterPanel_u24lambda_u240.setSecondComponent((JComponent)jbScrollPane);
            v0 = (JComponent)jBSplitter2;
        } else {
            v0 = panel2 = (JComponent)jbScrollPane;
        }
        if (this.threadDumps.isEmpty()) {
            return panel2;
        }
        JBSplitter $this$createCenterPanel_u24lambda_u241 = jBSplitter = new JBSplitter(true);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setFirstComponent(panel2);
        $this$createCenterPanel_u24lambda_u241.setSecondComponent(this.createThreadDumpBrowser());
        return (JComponent)jBSplitter;
    }

    private final JBScrollPane createReportTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Iterable $this$sortedBy$iv = LatenciometerKt.getLatencyMap().values();
        boolean $i$f$sortedBy = false;
        for (LatencyDistributionRecord row : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LatencyDistributionRecord it = (LatencyDistributionRecord)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey().getName());
                it = (LatencyDistributionRecord)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey().getName())));
            }
        })) {
            DefaultMutableTreeNode rowNode = new DefaultMutableTreeNode(row);
            root.add(rowNode);
            Iterable $this$sortedByDescending$iv = row.getActionLatencyRecords().entrySet();
            boolean $i$f$sortedByDescending = false;
            Iterator iterator2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency()));
                }
            }).iterator();
            while (iterator2.hasNext()) {
                Map.Entry actionLatencyRecord;
                Map.Entry entry = actionLatencyRecord = (Map.Entry)iterator2.next();
                rowNode.add(new DefaultMutableTreeNode(new Pair(entry.getKey(), entry.getValue())));
            }
        }
        Tree reportList = new Tree((TreeModel)new DefaultTreeModel(root));
        reportList.setRootVisible(false);
        reportList.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(this){
            final /* synthetic */ TypingLatencyReportDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                if (value == null) {
                    return;
                }
                Object obj = ((DefaultMutableTreeNode)value).getUserObject();
                if (obj instanceof LatencyDistributionRecord) {
                    this.append(TypingLatencyReportDialog.access$formatLatency(this.this$0, ((LatencyDistributionRecord)obj).getKey().getName(), ((LatencyDistributionRecord)obj).getTotalLatency(), ((LatencyDistributionRecord)obj).getKey().getDetails()));
                } else if (obj instanceof Pair) {
                    Object object = ((Pair)obj).getFirst();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    String string2 = (String)object;
                    Object object2 = ((Pair)obj).getSecond();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.internal.performance.LatencyRecord");
                    this.append(TypingLatencyReportDialog.formatLatency$default(this.this$0, string2, (LatencyRecord)object2, null, 4, null));
                }
            }
        });
        TreeUtil.expandAll((JTree)((JTree)reportList));
        return new JBScrollPane((Component)reportList);
    }

    private final String formatLatency(String action2, LatencyRecord latencyRecord, String details2) {
        String result2 = action2 + " - avg " + latencyRecord.getAverageLatency() + " ms, max " + latencyRecord.getMaxLatency() + " ms, 90% percentile " + latencyRecord.percentile(90) + " ms";
        if (details2 != null) {
            return result2 + ", " + details2;
        }
        return result2;
    }

    static /* synthetic */ String formatLatency$default(TypingLatencyReportDialog typingLatencyReportDialog, String string2, LatencyRecord latencyRecord, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return typingLatencyReportDialog.formatLatency(string2, latencyRecord, string3);
    }

    /*
     * WARNING - void declaration
     */
    private final String formatHeader(boolean htmlStyle) {
        String string2;
        if (htmlStyle) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = LatenciometerKt.getLatencyRecorderProperties();
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add("- " + key + ": " + value);
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"<br/>", (CharSequence)"<html>Latency Recorder Properties<br/>", (CharSequence)"</html>", (int)0, null, null, (int)56, null);
        } else {
            Map $this$map$iv = LatenciometerKt.getLatencyRecorderProperties();
            boolean $i$f$map = false;
            Map $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add("  - " + key + ": " + value);
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", (CharSequence)"Latency Recorder Properties\n", null, (int)0, null, null, (int)60, null);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createThreadDumpBrowser() {
        void $this$createThreadDumpBrowser_u24lambda_u249;
        JButton $this$createThreadDumpBrowser_u24lambda_u247;
        JButton jButton;
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"getInstance().createBuilder(project)");
        TextConsoleBuilder builder2 = textConsoleBuilder;
        builder2.filters(AnalyzeStacktraceUtil.EP_NAME.getExtensions(this.project));
        ConsoleView consoleView = builder2.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"builder.console");
        this.consoleView = consoleView;
        Disposable disposable = this.getDisposable();
        ConsoleView consoleView2 = this.consoleView;
        if (consoleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            consoleView2 = null;
        }
        Disposer.register(disposable, (Disposable)consoleView2);
        JBBox buttonsPanel = JBBox.createHorizontalBox();
        JButton jButton2 = jButton = new JButton("<<");
        TypingLatencyReportDialog typingLatencyReportDialog = this;
        boolean bl = false;
        $this$createThreadDumpBrowser_u24lambda_u247.addActionListener(arg_0 -> TypingLatencyReportDialog.createThreadDumpBrowser$lambda$7$lambda$6(this, arg_0));
        typingLatencyReportDialog.prevThreadDumpButton = jButton;
        $this$createThreadDumpBrowser_u24lambda_u247 = jButton = new JButton(">>");
        typingLatencyReportDialog = this;
        boolean bl2 = false;
        $this$createThreadDumpBrowser_u24lambda_u249.addActionListener(arg_0 -> TypingLatencyReportDialog.createThreadDumpBrowser$lambda$9$lambda$8(this, arg_0));
        typingLatencyReportDialog.nextThreadDumpButton = jButton;
        JButton jButton3 = this.prevThreadDumpButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prevThreadDumpButton");
            jButton3 = null;
        }
        buttonsPanel.add((Component)jButton3);
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton jButton4 = this.nextThreadDumpButton;
        if (jButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadDumpButton");
            jButton4 = null;
        }
        buttonsPanel.add((Component)jButton4);
        this.updateCurrentThreadDump();
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel();
        ConsoleView consoleView3 = this.consoleView;
        if (consoleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            consoleView3 = null;
        }
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel.addToCenter(consoleView3.getComponent()).addToBottom((Component)buttonsPanel);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"simplePanel().addToCente\u2026addToBottom(buttonsPanel)");
        return borderLayoutPanel2;
    }

    private final void updateCurrentThreadDump() {
        ConsoleView consoleView = this.consoleView;
        if (consoleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            consoleView = null;
        }
        consoleView.clear();
        ConsoleView consoleView2 = this.consoleView;
        if (consoleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            consoleView2 = null;
        }
        consoleView2.print(this.threadDumps.get(this.currentThreadDump), ConsoleViewContentType.NORMAL_OUTPUT);
        ConsoleView consoleView3 = this.consoleView;
        if (consoleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            consoleView3 = null;
        }
        consoleView3.scrollTo(0);
        JButton jButton = this.prevThreadDumpButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prevThreadDumpButton");
            jButton = null;
        }
        jButton.setEnabled(this.currentThreadDump > 0);
        JButton jButton2 = this.nextThreadDumpButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadDumpButton");
            jButton2 = null;
        }
        jButton2.setEnabled(this.currentThreadDump < this.threadDumps.size() - 1);
    }

    private final String formatReportAsText() {
        StringBuilder stringBuilder;
        StringBuilder $this$formatReportAsText_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$formatReportAsText_u24lambda_u2412.append(this.formatHeader(false));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        StringsKt.appendln((StringBuilder)$this$formatReportAsText_u24lambda_u2412);
        Iterable $this$sortedBy$iv = LatenciometerKt.getLatencyMap().values();
        boolean $i$f$sortedBy = false;
        for (LatencyDistributionRecord row : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LatencyDistributionRecord it = (LatencyDistributionRecord)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey().getName());
                it = (LatencyDistributionRecord)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey().getName())));
            }
        })) {
            StringBuilder stringBuilder3 = $this$formatReportAsText_u24lambda_u2412.append(this.formatLatency(row.getKey().getName(), row.getTotalLatency(), row.getKey().getDetails()));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            StringBuilder stringBuilder4 = $this$formatReportAsText_u24lambda_u2412.append("Actions:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            Iterable $this$sortedByDescending$iv = row.getActionLatencyRecords().entrySet();
            boolean $i$f$sortedByDescending = false;
            for (Map.Entry actionLatencyRecord : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency()));
                }
            })) {
                StringBuilder stringBuilder5 = $this$formatReportAsText_u24lambda_u2412.append("  " + TypingLatencyReportDialog.formatLatency$default(this, (String)actionLatencyRecord.getKey(), (LatencyRecord)actionLatencyRecord.getValue(), null, 4, null));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder5);
            }
        }
        StringsKt.appendln((StringBuilder)$this$formatReportAsText_u24lambda_u2412);
        if (!((Collection)this.threadDumps).isEmpty()) {
            StringBuilder stringBuilder6 = $this$formatReportAsText_u24lambda_u2412.append("Thread dumps:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
            for (String threadDump : this.threadDumps) {
                StringBuilder stringBuilder7 = $this$formatReportAsText_u24lambda_u2412.append(threadDump);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder7);
                StringBuilder stringBuilder8 = $this$formatReportAsText_u24lambda_u2412.append(StringsKt.repeat((CharSequence)"-", (int)40));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder8);
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[2];
        actionArray[0] = new ExportToFileAction();
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"okAction");
        return actionArray;
    }

    private static final void createThreadDumpBrowser$lambda$7$lambda$6(TypingLatencyReportDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int n = this$0.currentThreadDump;
        this$0.currentThreadDump = n + -1;
        this$0.updateCurrentThreadDump();
    }

    private static final void createThreadDumpBrowser$lambda$9$lambda$8(TypingLatencyReportDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int n = this$0.currentThreadDump;
        this$0.currentThreadDump = n + 1;
        this$0.updateCurrentThreadDump();
    }

    public static final /* synthetic */ String access$formatLatency(TypingLatencyReportDialog $this, String action2, LatencyRecord latencyRecord, String details2) {
        return $this.formatLatency(action2, latencyRecord, details2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/performance/TypingLatencyReportDialog$ExportToFileAction;", "Ljavax/swing/AbstractAction;", "(Lcom/intellij/internal/performance/TypingLatencyReportDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.platform.lang.impl"})
    private final class ExportToFileAction
    extends AbstractAction {
        public ExportToFileAction() {
            super("Export to File");
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String[] stringArray = new String[]{"txt"};
            FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Export Typing Latency Report", "File name:", stringArray);
            FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, (Component)TypingLatencyReportDialog.this.getContentPane());
            Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"getInstance().createSave\u2026(descriptor, contentPane)");
            FileSaverDialog dialog = fileSaverDialog;
            VirtualFileWrapper virtualFileWrapper = dialog.save(null, "typing-latency.txt");
            if (virtualFileWrapper == null) {
                return;
            }
            VirtualFileWrapper virtualFileWrapper2 = virtualFileWrapper;
            FileUtil.writeToFile(virtualFileWrapper2.getFile(), TypingLatencyReportDialog.this.formatReportAsText());
        }
    }
}

