/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.internal.retype.RetypeSession;
import com.intellij.internal.retype.RetypeSessionKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.LightColors;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0005\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/retype/RetypeEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "intellij.platform.lang.impl"})
public final class RetypeEditorNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return arg_0 -> RetypeEditorNotificationProvider.collectNotificationData$lambda$0(this, arg_0);
    }

    private final EditorNotificationPanel createNotificationPanel(FileEditor fileEditor) {
        if (!(fileEditor instanceof PsiAwareTextEditorImpl)) {
            return null;
        }
        RetypeSession retypeSession = (RetypeSession)((PsiAwareTextEditorImpl)fileEditor).getEditor().getUserData(RetypeSessionKt.getRETYPE_SESSION_KEY());
        if (retypeSession == null) {
            return null;
        }
        EditorNotificationPanel panel2 = null;
        if (retypeSession.getRetypePaused()) {
            panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
            panel2.setText("Pause retyping. Click on editor to resume");
        } else {
            panel2 = new EditorNotificationPanel(LightColors.SLIGHTLY_GREEN, EditorNotificationPanel.Status.Info);
            panel2.setText("Retyping");
        }
        panel2.createActionLabel("Stop without report", () -> RetypeEditorNotificationProvider.createNotificationPanel$lambda$1(retypeSession));
        return panel2;
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(RetypeEditorNotificationProvider this$0, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createNotificationPanel(it);
    }

    private static final void createNotificationPanel$lambda$1(RetypeSession $retypeSession) {
        $retypeSession.stop(false);
    }
}

