/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.internal.performance.LatenciometerKt;
import com.intellij.internal.retype.RetypeOptions;
import com.intellij.internal.retype.RetypeOptionsDialog;
import com.intellij.internal.retype.RetypeQueue;
import com.intellij.internal.retype.RetypeSession;
import com.intellij.internal.retype.RetypeSessionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/retype/RetypeFileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectSizeSampledFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "extension", "", "count", "", "queue", "Lcom/intellij/internal/retype/RetypeQueue;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "CandidateFile", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nRetypeFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetypeFileAction.kt\ncom/intellij/internal/retype/RetypeFileAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1002#2,2:170\n*S KotlinDebug\n*F\n+ 1 RetypeFileAction.kt\ncom/intellij/internal/retype/RetypeFileAction\n*L\n79#1:170,2\n*E\n"})
public final class RetypeFileAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        RetypeSession existingSession;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.EDITOR);
        EditorImpl editor2 = object instanceof EditorImpl ? (EditorImpl)object : null;
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        EditorImpl editorImpl = editor2;
        RetypeSession retypeSession = existingSession = editorImpl != null ? (RetypeSession)editorImpl.getUserData(RetypeSessionKt.getRETYPE_SESSION_KEY()) : null;
        if (existingSession != null) {
            existingSession.stop(false);
        } else {
            RetypeOptions retypeOptions = new RetypeOptions(project3);
            RetypeOptionsDialog retypeOptionsDialog = new RetypeOptionsDialog(project3, retypeOptions, (Editor)editor2);
            if (!retypeOptionsDialog.showAndGet()) {
                return;
            }
            StringBuilder scriptBuilder = retypeOptions.getRecordScript() ? new StringBuilder() : null;
            int largeIndexFileCount = retypeOptions.getEnableLargeIndexing() ? retypeOptions.getLargeIndexFilesCount() : -1;
            LatenciometerKt.getLatencyMap().clear();
            if (retypeOptions.getRetypeCurrentFile()) {
                EditorImpl editorImpl2 = editor2;
                Intrinsics.checkNotNull((Object)editorImpl2);
                EditorImpl editorImpl3 = editorImpl2;
                int n = retypeOptions.getRetypeDelay();
                int n2 = retypeOptions.getThreadDumpDelay();
                boolean bl = retypeOptions.getRestoreOriginalText();
                RetypeSession session = new RetypeSession(project3, editorImpl3, n, scriptBuilder, n2, null, largeIndexFileCount, bl, 32, null);
                session.start();
            } else {
                RetypeQueue queue2 = new RetypeQueue(project3, retypeOptions.getRetypeDelay(), retypeOptions.getThreadDumpDelay(), scriptBuilder, largeIndexFileCount, retypeOptions.getRestoreOriginalText());
                if (!this.collectSizeSampledFiles(project3, StringsKt.removePrefix((String)retypeOptions.getRetypeExtension(), (CharSequence)"."), retypeOptions.getFileCount(), queue2)) {
                    return;
                }
                queue2.processNext();
            }
        }
    }

    private final boolean collectSizeSampledFiles(Project project2, String extension2, int count2, RetypeQueue queue2) {
        List candidates = new ArrayList();
        boolean result2 = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> RetypeFileAction.collectSizeSampledFiles$lambda$1(project2, extension2, candidates), "Scanning files", true, project2);
        if (!result2) {
            return false;
        }
        List $this$sortBy$iv = candidates;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CandidateFile it = (CandidateFile)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getSize());
                    it = (CandidateFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSize()));
                }
            });
        }
        if (count2 == 1) {
            queue2.getFiles().add(((CandidateFile)candidates.get(new Random().nextInt(candidates.size()))).getVirtualFile());
        } else {
            int stride = candidates.size() / (count2 - 1);
            int n = candidates.size();
            if (stride <= 0) {
                throw new IllegalArgumentException("Step must be positive, was: " + stride + ".");
            }
            int index2 = 0;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)stride);
            if (index2 <= n2) {
                while (true) {
                    queue2.getFiles().add(((CandidateFile)candidates.get(RangesKt.coerceAtMost((int)index2, (int)(candidates.size() - 1)))).getVirtualFile());
                    if (index2 == n2) break;
                    index2 += stride;
                }
            }
        }
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        e.getPresentation().setEnabled(e.getProject() != null);
        Editor editor3 = editor2;
        RetypeSession retypeSession = editor3 != null ? (RetypeSession)editor3.getUserData(RetypeSessionKt.getRETYPE_SESSION_KEY()) : null;
        e.getPresentation().setText(retypeSession != null ? "Stop Retyping" : "Retype File(s)");
    }

    private static final boolean collectSizeSampledFiles$lambda$1$lambda$0(String $extension, List $candidates, VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$candidates, (String)"$candidates");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ProgressManager.checkCanceled();
        if (Intrinsics.areEqual((Object)file2.getExtension(), (Object)$extension) && file2.getLength() > 0L) {
            $candidates.add(new CandidateFile(file2, file2.getLength()));
        }
        return true;
    }

    private static final void collectSizeSampledFiles$lambda$1(Project $project, String $extension, List $candidates) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$candidates, (String)"$candidates");
        ProjectRootManager.getInstance($project).getFileIndex().iterateContent(arg_0 -> RetypeFileAction.collectSizeSampledFiles$lambda$1$lambda$0($extension, $candidates, arg_0));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/retype/RetypeFileAction$CandidateFile;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "size", "", "(Lcom/intellij/openapi/vfs/VirtualFile;J)V", "getSize", "()J", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class CandidateFile {
        @NotNull
        private final VirtualFile virtualFile;
        private final long size;

        public CandidateFile(@NotNull VirtualFile virtualFile2, long size) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            this.virtualFile = virtualFile2;
            this.size = size;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.virtualFile;
        }

        public final long component2() {
            return this.size;
        }

        @NotNull
        public final CandidateFile copy(@NotNull VirtualFile virtualFile2, long size) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            return new CandidateFile(virtualFile2, size);
        }

        public static /* synthetic */ CandidateFile copy$default(CandidateFile candidateFile, VirtualFile virtualFile2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = candidateFile.virtualFile;
            }
            if ((n & 2) != 0) {
                l = candidateFile.size;
            }
            return candidateFile.copy(virtualFile2, l);
        }

        @NotNull
        public String toString() {
            return "CandidateFile(virtualFile=" + this.virtualFile + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result2 = this.virtualFile.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.size);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CandidateFile)) {
                return false;
            }
            CandidateFile candidateFile = (CandidateFile)other;
            if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)candidateFile.virtualFile)) {
                return false;
            }
            return this.size == candidateFile.size;
        }
    }
}

