/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.IdeEventQueue;
import com.intellij.internal.performance.LatenciometerKt;
import com.intellij.internal.performance.LatencyDistributionRecordKey;
import com.intellij.internal.performance.TypingLatencyReportDialog;
import com.intellij.internal.retype.RetypeFileAssistant;
import com.intellij.internal.retype.RetypeLog;
import com.intellij.internal.retype.RetypeSessionKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyRecorder;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 Y2\u00020\u0001:\u0001YBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010A\u001a\u000200H\u0002J\u0010\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000eH\u0002J\b\u0010D\u001a\u000200H\u0016J\u0018\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u001fH\u0002J\b\u0010H\u001a\u00020\u0011H\u0002J\b\u0010I\u001a\u00020\u0011H\u0002J\b\u0010J\u001a\u000200H\u0002J\b\u0010K\u001a\u000200H\u0002J\b\u0010L\u001a\u000200H\u0002J\u0006\u0010M\u001a\u000200J\b\u0010N\u001a\u000200H\u0002J\u000e\u0010O\u001a\u0002002\u0006\u0010P\u001a\u00020\u0011J\b\u0010Q\u001a\u000200H\u0002J\u0018\u0010R\u001a\u0002002\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010S\u001a\u00020\u001fH\u0002J\u0016\u0010T\u001a\u0002002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0UH\u0002J\u0014\u0010V\u001a\u00020\u0011*\u00020W2\u0006\u0010X\u001a\u00020\u0007H\u0002R\u0016\u0010\u0013\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010%\u001a\f0\u000e\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0016\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u00105\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/intellij/internal/retype/RetypeSession;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "delayMillis", "", "scriptBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "threadDumpDelay", "threadDumps", "", "", "filesForIndexCount", "restoreText", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/impl/EditorImpl;ILjava/lang/StringBuilder;ILjava/util/List;IZ)V", "code", "getCode", "()Ljava/lang/String;", "completionStack", "Ljava/util/ArrayDeque;", "disposeLock", "", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "Lorg/jetbrains/annotations/NotNull;", "endPos", "lastTimerTick", "", "log", "Lcom/intellij/internal/retype/RetypeLog;", "oldAddUnambiguous", "oldOptimize", "oldSelectAutopopup", "originalText", "Lcom/intellij/openapi/util/NlsSafe;", "pos", "retypePaused", "getRetypePaused", "()Z", "setRetypePaused", "(Z)V", "skipLookupSuggestion", "startNextCallback", "Lkotlin/Function0;", "", "getStartNextCallback", "()Lkotlin/jvm/functions/Function0;", "setStartNextCallback", "(Lkotlin/jvm/functions/Function0;)V", "stopInterfereFileChanger", "stopTimer", "tailLength", "textBeforeLookupSelection", "threadDumpAlarm", "Lcom/intellij/util/Alarm;", "threadPoolTimerLag", "timerThread", "Ljava/lang/Thread;", "totalTimerLag", "typedRightBefore", "waitingForTimerInvokeLater", "checkStop", "correctText", "text", "dispose", "executeEditorAction", "actionId", "timerTick", "handleIdeaIntelligence", "inFocus", "logThreadDump", "removeLargeIndexing", "runLoop", "start", "startLargeIndexing", "stop", "startNext", "typeNext", "typeNextInEDT", "expectedTimerTick", "updateStack", "Ljava/util/Deque;", "shouldAccept", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupStartOffset", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nRetypeSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetypeSession.kt\ncom/intellij/internal/retype/RetypeSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,627:1\n1855#2,2:628\n1549#2:630\n1620#2,3:631\n1855#2,2:634\n*S KotlinDebug\n*F\n+ 1 RetypeSession.kt\ncom/intellij/internal/retype/RetypeSession\n*L\n439#1:628,2\n485#1:630\n485#1:631,3\n485#1:634,2\n*E\n"})
public final class RetypeSession
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorImpl editor;
    private final int delayMillis;
    @Nullable
    private final StringBuilder scriptBuilder;
    private final int threadDumpDelay;
    @NotNull
    private final List<String> threadDumps;
    private final int filesForIndexCount;
    private final boolean restoreText;
    @NotNull
    private final DocumentEx document;
    @NotNull
    private final Alarm threadDumpAlarm;
    @NotNull
    private final String originalText;
    private volatile int pos;
    private final int endPos;
    private final int tailLength;
    @NotNull
    private final RetypeLog log;
    private final boolean oldSelectAutopopup;
    private final boolean oldAddUnambiguous;
    private final boolean oldOptimize;
    @Nullable
    private Function0<Unit> startNextCallback;
    @NotNull
    private final Object disposeLock;
    private boolean typedRightBefore;
    private boolean skipLookupSuggestion;
    @Nullable
    private String textBeforeLookupSelection;
    private volatile boolean waitingForTimerInvokeLater;
    private long lastTimerTick;
    private long threadPoolTimerLag;
    private long totalTimerLag;
    @NotNull
    private final ArrayDeque<String> completionStack;
    private boolean stopInterfereFileChanger;
    private boolean retypePaused;
    @NotNull
    private final Thread timerThread;
    private boolean stopTimer;
    @Language(value="JAVA")
    @NotNull
    private final String code;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String INTERFERE_FILE_NAME = "IdeaRetypeBackgroundChanges.java";
    @NotNull
    public static final String LARGE_INDEX_DIR_NAME = "_indexDir_";

    public RetypeSession(@NotNull Project project2, @NotNull EditorImpl editor2, int delayMillis, @Nullable StringBuilder scriptBuilder, int threadDumpDelay, @NotNull List<String> threadDumps, int filesForIndexCount, boolean restoreText) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(threadDumps, (String)"threadDumps");
        this.project = project2;
        this.editor = editor2;
        this.delayMillis = delayMillis;
        this.scriptBuilder = scriptBuilder;
        this.threadDumpDelay = threadDumpDelay;
        this.threadDumps = threadDumps;
        this.filesForIndexCount = filesForIndexCount;
        this.restoreText = restoreText;
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        this.document = documentEx;
        this.threadDumpAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        String string2 = this.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        this.originalText = string2;
        this.log = new RetypeLog();
        this.oldSelectAutopopup = CodeInsightSettings.getInstance().SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
        this.oldAddUnambiguous = CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
        this.oldOptimize = CodeInsightWorkspaceSettings.getInstance(this.project).isOptimizeImportsOnTheFly();
        this.disposeLock = new Object();
        this.lastTimerTick = -1L;
        this.completionStack = new ArrayDeque();
        this.timerThread = new Thread(this::runLoop, "RetypeSession loop");
        if (this.editor.getSelectionModel().hasSelection()) {
            this.pos = this.editor.getSelectionModel().getSelectionStart();
            this.endPos = this.editor.getSelectionModel().getSelectionEnd();
        } else {
            this.pos = this.editor.getCaretModel().getOffset();
            this.endPos = this.document.getTextLength();
        }
        this.tailLength = this.document.getTextLength() - this.endPos;
        this.code = "final class MyClass {\n    public static void main1(String[] args) {\n      int x = 5;\n    }\n}";
    }

    public /* synthetic */ RetypeSession(Project project2, EditorImpl editorImpl, int n, StringBuilder stringBuilder, int n2, List list2, int n3, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x20) != 0) {
            list2 = new ArrayList();
        }
        if ((n4 & 0x40) != 0) {
            n3 = -1;
        }
        if ((n4 & 0x80) != 0) {
            bl = !ApplicationManager.getApplication().isUnitTestMode();
        }
        this(project2, editorImpl, n, stringBuilder, n2, list2, n3, bl);
    }

    @Nullable
    public final Function0<Unit> getStartNextCallback() {
        return this.startNextCallback;
    }

    public final void setStartNextCallback(@Nullable Function0<Unit> function0) {
        this.startNextCallback = function0;
    }

    public final boolean getRetypePaused() {
        return this.retypePaused;
    }

    public final void setRetypePaused(boolean bl) {
        this.retypePaused = bl;
    }

    public final void start() {
        Object object;
        block2: {
            StringBuilder it;
            block3: {
                this.editor.putUserData(RetypeSessionKt.getRETYPE_SESSION_KEY(), (Object)this);
                VirtualFile vFile = FileDocumentManager.getInstance().getFile(this.document);
                Object object2 = vFile;
                if (object2 == null || (object2 = ((VirtualFile)object2).getName()) == null) {
                    object2 = "Unknown file";
                }
                String keyName = (String)object2 + " (" + this.document.getTextLength() + " chars)";
                LatenciometerKt.setCurrentLatencyRecordKey((LatencyDistributionRecordKey)new LatencyDistributionRecordKey(keyName));
                object = new Pair[]{TuplesKt.to((Object)"Delay", (Object)(this.delayMillis + " ms")), TuplesKt.to((Object)"Thread dump delay", (Object)(this.threadDumpDelay + " ms"))};
                LatenciometerKt.getLatencyRecorderProperties().putAll(MapsKt.mapOf((Pair[])object));
                StringBuilder stringBuilder = this.scriptBuilder;
                if (stringBuilder == null) break block2;
                it = stringBuilder;
                boolean bl = false;
                if (vFile == null) break block3;
                VirtualFile virtualFile2 = ProjectRootManager.getInstance(this.project).getFileIndex().getContentRootForFile(vFile);
                if (virtualFile2 == null) break block2;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ProjectRootManager.getIn\u2026File(vFile) ?: return@let");
                VirtualFile contentRoot = virtualFile2;
                it.append("%openFile " + VfsUtil.getRelativePath(vFile, contentRoot) + "\n");
            }
            String string2 = this.originalText.substring(0, this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string3 = this.originalText.substring(this.endPos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            it.append(this.correctText(string2 + string3));
            int line = this.editor.getDocument().getLineNumber(this.pos);
            it.append("%goto " + (line + 1) + " " + (this.pos - this.editor.getDocument().getLineStartOffset(line) + 1) + "\n");
        }
        WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.start$lambda$1(this));
        Object $this$start_u24lambda_u242 = object = CodeInsightSettings.getInstance();
        boolean bl = false;
        $this$start_u24lambda_u242.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS = false;
        $this$start_u24lambda_u242.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY = false;
        CodeInsightWorkspaceSettings.getInstance(this.project).setOptimizeImportsOnTheFly(false);
        EditorNotifications.getInstance((Project)this.project).updateNotifications(this.editor.getVirtualFile());
        this.retypePaused = false;
        this.startLargeIndexing();
        this.timerThread.start();
        this.checkStop();
    }

    private final String correctText(String text2) {
        return "%replaceText " + StringsKt.replace$default((String)text2, (char)'\n', (char)'\u32e1', (boolean)false, (int)4, null) + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(boolean startNext) {
        this.stopTimer = true;
        this.timerThread.join();
        Object object = RetypeFileAssistant.Companion.getEP_NAME().getExtensions();
        int n = ((RetypeFileAssistant[])object).length;
        for (int j = 0; j < n; ++j) {
            RetypeFileAssistant retypeFileAssistant = object[j];
            retypeFileAssistant.retypeDone((Editor)this.editor);
        }
        if (this.restoreText) {
            WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.stop$lambda$3(this));
        }
        Object object2 = this.disposeLock;
        synchronized (object2) {
            boolean $i$a$-synchronized-RetypeSession$stop$32 = false;
            Disposer.dispose(this);
            Unit $i$a$-synchronized-RetypeSession$stop$32 = Unit.INSTANCE;
        }
        this.editor.putUserData(RetypeSessionKt.getRETYPE_SESSION_KEY(), null);
        Object $this$stop_u24lambda_u245 = object = CodeInsightSettings.getInstance();
        boolean bl = false;
        $this$stop_u24lambda_u245.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS = this.oldSelectAutopopup;
        $this$stop_u24lambda_u245.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY = this.oldAddUnambiguous;
        CodeInsightWorkspaceSettings.getInstance(this.project).setOptimizeImportsOnTheFly(this.oldOptimize);
        LatencyDistributionRecordKey latencyDistributionRecordKey = LatenciometerKt.getCurrentLatencyRecordKey();
        if (latencyDistributionRecordKey != null) {
            latencyDistributionRecordKey.setDetails("typed " + this.log.getTypedChars() + " chars, completed " + this.log.getCompletedChars() + " chars");
        }
        this.log.flush();
        this.log.printToStdout();
        LatenciometerKt.setCurrentLatencyRecordKey(null);
        if (startNext) {
            Function0<Unit> function0 = this.startNextCallback;
            if (function0 != null) {
                function0.invoke();
            }
        }
        this.removeLargeIndexing();
        this.stopInterfereFileChanger = true;
        EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
    }

    @Override
    public void dispose() {
    }

    private final boolean inFocus() {
        return Intrinsics.areEqual((Object)this.editor.getContentComponent(), (Object)IdeFocusManager.findInstance().getFocusOwner()) && ApplicationManager.getApplication().isActive() || ApplicationManager.getApplication().isUnitTestMode();
    }

    private final void runLoop() {
        while (this.pos != this.endPos && !this.stopTimer) {
            Thread.sleep(this.delayMillis);
            if (this.stopTimer) break;
            this.typeNext();
        }
    }

    private final void typeNext() {
        long expectedTimerTick;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.threadDumpAlarm.addRequest(() -> RetypeSession.typeNext$lambda$6(this), this.threadDumpDelay);
        }
        long timerTick = System.currentTimeMillis();
        this.waitingForTimerInvokeLater = true;
        long l = expectedTimerTick = this.lastTimerTick != -1L ? this.lastTimerTick + (long)this.delayMillis : -1L;
        if (this.lastTimerTick != -1L) {
            this.threadPoolTimerLag += timerTick - expectedTimerTick;
        }
        this.lastTimerTick = timerTick;
        ApplicationManager.getApplication().invokeLater(() -> RetypeSession.typeNext$lambda$7(this, timerTick, expectedTimerTick));
    }

    private final void typeNextInEDT(long timerTick, long expectedTimerTick) {
        if (this.retypePaused) {
            if (this.inFocus()) {
                this.retypePaused = false;
            } else {
                this.checkStop();
                return;
            }
        }
        if (expectedTimerTick != -1L) {
            this.totalTimerLag += System.currentTimeMillis() - expectedTimerTick;
        }
        EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
        this.waitingForTimerInvokeLater = false;
        boolean processNextEvent = this.handleIdeaIntelligence();
        if (processNextEvent) {
            return;
        }
        if (TemplateManager.getInstance(this.project).getActiveTemplate((Editor)this.editor) != null) {
            TemplateManager.getInstance(this.project).finishTemplate((Editor)this.editor);
            this.checkStop();
            return;
        }
        LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup((Editor)this.editor);
        if (lookup2 != null && !this.skipLookupSuggestion) {
            LookupElement currentLookupElement;
            LookupElement lookupElement = currentLookupElement = lookup2.getCurrentItem();
            boolean bl = lookupElement != null ? this.shouldAccept(lookupElement, lookup2.getLookupStart()) : false;
            if (bl) {
                lookup2.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
                StringBuilder stringBuilder = this.scriptBuilder;
                if (stringBuilder != null) {
                    stringBuilder.append("%action EditorChooseLookupItem\n");
                }
                this.typedRightBefore = false;
                this.textBeforeLookupSelection = this.document.getText();
                this.executeEditorAction("EditorChooseLookupItem", timerTick);
                this.checkStop();
                return;
            }
        }
        if (!this.inFocus()) {
            this.retypePaused = true;
        }
        if (this.retypePaused) {
            this.checkStop();
            return;
        }
        if (this.editor.getCaretModel().getOffset() != this.pos) {
            this.editor.getCaretModel().moveToOffset(this.pos);
        }
        int n = this.pos;
        this.pos = n + 1;
        char c2 = this.originalText.charAt(n);
        this.log.recordTyping(c2);
        this.textBeforeLookupSelection = null;
        if (c2 == ' ') {
            this.skipLookupSuggestion = false;
        }
        if (c2 == '\n') {
            StringBuilder stringBuilder = this.scriptBuilder;
            if (stringBuilder != null) {
                stringBuilder.append("%action EditorEnter\n");
            }
            this.executeEditorAction("EditorEnter", timerTick);
            this.typedRightBefore = false;
        } else {
            StringBuilder stringBuilder = this.scriptBuilder;
            if (stringBuilder != null) {
                StringBuilder it = stringBuilder;
                boolean bl = false;
                if (this.typedRightBefore) {
                    it.deleteCharAt(it.length() - 1);
                    v5 = it.append(c2 + "\n");
                } else {
                    v5 = it.append("%delayType " + this.delayMillis + "|" + c2 + "\n");
                }
            } else {
                v5 = null;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.editor.type(String.valueOf(c2));
            } else {
                IdeEventQueue.Companion.getInstance().postEvent((AWTEvent)new KeyEvent(this.editor.getComponent(), 401, timerTick, 0, 0, c2));
                IdeEventQueue.Companion.getInstance().postEvent((AWTEvent)new KeyEvent(this.editor.getComponent(), 400, timerTick, 0, 0, c2));
            }
            this.typedRightBefore = true;
        }
        this.checkStop();
    }

    private final boolean handleIdeaIntelligence() {
        String string2 = this.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String actualBeforeCaret = StringsKt.take((String)string2, (int)this.pos);
        String expectedBeforeCaret = StringsKt.take((String)this.originalText, (int)this.pos);
        if (!Intrinsics.areEqual((Object)actualBeforeCaret, (Object)expectedBeforeCaret)) {
            if (this.textBeforeLookupSelection != null) {
                this.log.recordDesync("Restoring text before lookup (expected ..." + RetypeSessionKt.toReadable(StringsKt.takeLast((String)expectedBeforeCaret, (int)5)) + ", actual ..." + RetypeSessionKt.toReadable(StringsKt.takeLast((String)actualBeforeCaret, (int)5)) + " ");
                WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.handleIdeaIntelligence$lambda$9(this));
                this.skipLookupSuggestion = true;
            } else {
                this.log.recordDesync("Restoring text before caret (expected ..." + RetypeSessionKt.toReadable(StringsKt.takeLast((String)expectedBeforeCaret, (int)5)) + ", actual ..." + RetypeSessionKt.toReadable(StringsKt.takeLast((String)actualBeforeCaret, (int)5)) + " | pos: " + this.pos + ", caretOffset: " + this.editor.getCaretModel().getOffset());
                WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.handleIdeaIntelligence$lambda$10(this, expectedBeforeCaret));
            }
        }
        if (this.editor.getCaretModel().getOffset() > this.pos) {
            while (this.pos < this.document.getTextLength() - this.tailLength && this.originalText.charAt(this.pos) == this.document.getText().charAt(this.pos) && !CollectionsKt.listOf((Object)Character.valueOf('\n')).contains(Character.valueOf(this.document.getText().charAt(this.pos)))) {
                this.log.recordCompletion(this.document.getText().charAt(this.pos));
                int n = this.pos;
                this.pos = n + 1;
            }
            if (this.editor.getCaretModel().getOffset() > this.pos) {
                String string3 = this.document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"document.text");
                String string4 = string3;
                int n = this.pos;
                int n2 = this.editor.getCaretModel().getOffset();
                String string5 = string4.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.log.recordDesync("Deleting extra characters: " + RetypeSessionKt.toReadable(string5));
                WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.handleIdeaIntelligence$lambda$11(this));
            }
            this.editor.getCaretModel().moveToOffset(this.pos);
        }
        if (this.document.getTextLength() > this.pos + this.tailLength) {
            this.updateStack((Deque<String>)this.completionStack);
            String firstCompletion = this.completionStack.peekLast();
            if (firstCompletion != null) {
                String string6 = this.originalText.substring(this.pos, this.endPos);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                int origIndexOfFirstCompletion = StringsKt.indexOf$default((CharSequence)((Object)StringsKt.trim((CharSequence)string6)).toString(), (String)firstCompletion, (int)0, (boolean)false, (int)6, null);
                if (origIndexOfFirstCompletion == 0) {
                    String string7 = this.originalText.substring(this.pos, this.endPos);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    int origIndexOfFirstComp = StringsKt.indexOf$default((CharSequence)string7, (String)firstCompletion, (int)0, (boolean)false, (int)6, null);
                    String string8 = this.document.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"document.text");
                    String string9 = string8;
                    int n = this.pos;
                    String string10 = string9.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String).substring(startIndex)");
                    int docIndexOfFirstComp = StringsKt.indexOf$default((CharSequence)string10, (String)firstCompletion, (int)0, (boolean)false, (int)6, null);
                    String string11 = this.originalText.substring(this.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).substring(startIndex)");
                    String string12 = StringsKt.take((String)string11, (int)origIndexOfFirstComp);
                    String string13 = this.document.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"document.text");
                    string9 = string13;
                    n = this.pos;
                    String string14 = string9.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"this as java.lang.String).substring(startIndex)");
                    if (!Intrinsics.areEqual((Object)string12, (Object)StringsKt.take((String)string14, (int)origIndexOfFirstComp))) {
                        WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.handleIdeaIntelligence$lambda$12(this, origIndexOfFirstComp, docIndexOfFirstComp));
                    }
                    Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)this.pos, (int)(this.pos + origIndexOfFirstComp + firstCompletion.length()));
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl = false;
                        this.log.recordCompletion(this.document.getText().charAt(it));
                    }
                    this.pos += origIndexOfFirstComp + firstCompletion.length();
                    this.editor.getCaretModel().moveToOffset(this.pos);
                    this.completionStack.removeLast();
                    this.checkStop();
                    return true;
                }
                if (origIndexOfFirstCompletion < 0) {
                    String string15 = this.document.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"document.text");
                    String string16 = string15;
                    int n = this.pos;
                    String string17 = string16.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"this as java.lang.String).substring(startIndex)");
                    int docIndexOfFirstComp = StringsKt.indexOf$default((CharSequence)string17, (String)firstCompletion, (int)0, (boolean)false, (int)6, null);
                    String string18 = this.document.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"document.text");
                    string16 = string18;
                    n = this.pos;
                    int n3 = this.pos + docIndexOfFirstComp;
                    String string19 = string16.substring(n, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    this.log.recordDesync("Removing wrong completion: " + RetypeSessionKt.toReadable(string19));
                    WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.handleIdeaIntelligence$lambda$14(this, docIndexOfFirstComp, firstCompletion));
                    this.completionStack.removeLast();
                    this.checkStop();
                    return true;
                }
            }
        } else if (this.document.getTextLength() == this.pos + this.tailLength && !((Collection)this.completionStack).isEmpty()) {
            this.completionStack.clear();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStack(Deque<String> completionStack) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string2 = this.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String string3 = string2;
        int n = this.pos;
        int n2 = this.document.getTextLength() - this.tailLength;
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String unexpectedCharsDoc = string4;
        int endPosDoc = unexpectedCharsDoc.length();
        Iterator<String> iterator2 = completionStack.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"completionStack.iterator()");
        Iterator<String> completionIterator = iterator2;
        while (completionIterator.hasNext()) {
            String completion = completionIterator.next();
            String string5 = unexpectedCharsDoc.substring(0, endPosDoc);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            CharSequence charSequence = string5;
            Intrinsics.checkNotNullExpressionValue((Object)completion, (String)"completion");
            int lastIndexOfCompletion = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)completion, (int)0, (boolean)false, (int)6, null);
            if (lastIndexOfCompletion < 0) {
                completionIterator.remove();
                continue;
            }
            endPosDoc = lastIndexOfCompletion;
        }
        String string6 = unexpectedCharsDoc.substring(0, endPosDoc);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Object completion = ((Object)StringsKt.trim((CharSequence)string6)).toString();
        Regex lastIndexOfCompletion = new Regex("\\s+");
        int n3 = 0;
        completion = lastIndexOfCompletion.split((CharSequence)completion, n3);
        boolean $i$f$map = false;
        Iterator iterator3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string7 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0)) continue;
            completionStack.add(it);
        }
    }

    private final void checkStop() {
        if (this.pos == this.endPos) {
            this.stop(true);
            if (this.startNextCallback == null && !ApplicationManager.getApplication().isUnitTestMode()) {
                if (this.scriptBuilder != null) {
                    this.scriptBuilder.append(this.correctText(this.originalText));
                    File file2 = File.createTempFile("perf", ".test");
                    VirtualFile virtualFile2 = VfsUtil.findFileByIoFile(file2, false);
                    Intrinsics.checkNotNull((Object)virtualFile2);
                    VirtualFile vFile = virtualFile2;
                    WriteCommandAction.runWriteCommandAction(this.project, () -> RetypeSession.checkStop$lambda$17(vFile, this));
                    new OpenFileDescriptor(this.project, vFile).navigate(true);
                }
                LatenciometerKt.getLatencyRecorderProperties().put("Thread pool timer lag", this.threadPoolTimerLag + " ms");
                LatenciometerKt.getLatencyRecorderProperties().put("Total timer lag", this.totalTimerLag + " ms");
                new TypingLatencyReportDialog(this.project, this.threadDumps).show();
            }
        }
    }

    private final boolean shouldAccept(LookupElement $this$shouldAccept, int lookupStartOffset) {
        String string2;
        for (RetypeFileAssistant retypeFileAssistant : RetypeFileAssistant.Companion.getEP_NAME().getExtensionList()) {
            if (retypeFileAssistant.acceptLookupElement($this$shouldAccept)) continue;
            return false;
        }
        if ($this$shouldAccept instanceof LiveTemplateLookupElement) {
            return false;
        }
        try {
            String string3 = LookupElementPresentation.renderElement($this$shouldAccept).getItemText();
            if (string3 == null) {
                return false;
            }
            string2 = string3;
        }
        catch (Exception e) {
            return false;
        }
        String lookupString = string2;
        String string4 = this.originalText.substring(lookupStartOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        String textAtLookup = string4;
        if (!Intrinsics.areEqual((Object)StringsKt.take((String)textAtLookup, (int)lookupString.length()), (Object)lookupString)) {
            return false;
        }
        return textAtLookup.length() == lookupString.length() || !Character.isJavaIdentifierPart((char)(textAtLookup.charAt(lookupString.length()) + '\u0001'));
    }

    private final void executeEditorAction(String actionId, long timerTick) {
        ActionManagerEx actionManager = ActionManagerEx.Companion.getInstanceEx();
        AnAction action2 = actionManager.getAction(actionId);
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)this.editor.getDataContext());
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(actio\u2026, \"\", editor.dataContext)");
        AnActionEvent event = anActionEvent;
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false)) {
            ActionUtil.performDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event, () -> RetypeSession.executeEditorAction$lambda$18(this, actionId, timerTick, action2, event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logThreadDump() {
        if (this.editor.isProcessingTypedAction() || this.waitingForTimerInvokeLater) {
            String string2 = ThreadDumper.dumpThreadsToString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dumpThreadsToString()");
            this.threadDumps.add(string2);
            if (this.threadDumps.size() > 200) {
                this.threadDumps.subList(0, 100).clear();
            }
            Object object = this.disposeLock;
            synchronized (object) {
                boolean bl = false;
                if (!this.threadDumpAlarm.isDisposed()) {
                    this.threadDumpAlarm.addRequest(() -> RetypeSession.logThreadDump$lambda$20$lambda$19(this), this.threadDumpDelay);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final void startLargeIndexing() {
        if (this.filesForIndexCount <= 0) {
            return;
        }
        File dir = new File(this.editor.getVirtualFile().getParent().getPath(), LARGE_INDEX_DIR_NAME);
        dir.mkdir();
        int i2 = 0;
        int n = this.filesForIndexCount;
        if (i2 <= n) {
            while (true) {
                File file2 = new File(dir, "MyClass" + i2 + ".java");
                file2.createNewFile();
                FilesKt.writeText$default((File)file2, (String)StringsKt.repeat((CharSequence)this.code, (int)500), null, (int)2, null);
                if (i2 == n) break;
                ++i2;
            }
        }
    }

    private final void removeLargeIndexing() {
        if (this.filesForIndexCount <= 0) {
            return;
        }
        File dir = new File(this.editor.getVirtualFile().getParent().getPath(), LARGE_INDEX_DIR_NAME);
        FilesKt.deleteRecursively((File)dir);
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    private static final void start$lambda$1(RetypeSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.document.deleteString(this$0.pos, this$0.endPos);
    }

    private static final void stop$lambda$3(RetypeSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.document.replaceString(0, this$0.document.getTextLength(), this$0.originalText);
    }

    private static final void typeNext$lambda$6(RetypeSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logThreadDump();
    }

    private static final void typeNext$lambda$7(RetypeSession this$0, long $timerTick, long $expectedTimerTick) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.stopTimer) {
            return;
        }
        this$0.typeNextInEDT($timerTick, $expectedTimerTick);
    }

    private static final void handleIdeaIntelligence$lambda$9(RetypeSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string2 = this$0.textBeforeLookupSelection;
        if (string2 == null) {
            return;
        }
        this$0.document.replaceText(string2, this$0.document.getModificationStamp() + 1L);
    }

    private static final void handleIdeaIntelligence$lambda$10(RetypeSession this$0, String $expectedBeforeCaret) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$expectedBeforeCaret, (String)"$expectedBeforeCaret");
        this$0.document.replaceString(0, this$0.editor.getCaretModel().getOffset(), $expectedBeforeCaret);
    }

    private static final void handleIdeaIntelligence$lambda$11(RetypeSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.document.deleteString(this$0.pos, this$0.editor.getCaretModel().getOffset());
    }

    private static final void handleIdeaIntelligence$lambda$12(RetypeSession this$0, int $origIndexOfFirstComp, int $docIndexOfFirstComp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string2 = this$0.originalText.substring(this$0.pos, this$0.pos + $origIndexOfFirstComp);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String replacement = string2;
        RetypeLog retypeLog = this$0.log;
        String string3 = this$0.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"document.text");
        String string4 = string3;
        int n = this$0.pos;
        int n2 = this$0.pos + $docIndexOfFirstComp;
        String string5 = string4.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        retypeLog.recordDesync("Replacing extra characters before completion: " + RetypeSessionKt.toReadable(string5) + " -> " + RetypeSessionKt.toReadable(replacement));
        this$0.document.replaceString(this$0.pos, this$0.pos + $docIndexOfFirstComp, replacement);
    }

    private static final void handleIdeaIntelligence$lambda$14(RetypeSession this$0, int $docIndexOfFirstComp, String $firstCompletion) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.document.replaceString(this$0.pos, this$0.pos + $docIndexOfFirstComp + $firstCompletion.length(), "");
    }

    private static final void checkStop$lambda$17(VirtualFile $vFile, RetypeSession this$0) {
        Intrinsics.checkNotNullParameter((Object)$vFile, (String)"$vFile");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VfsUtil.saveText($vFile, this$0.scriptBuilder.toString());
    }

    private static final void executeEditorAction$lambda$18(RetypeSession this$0, String $actionId, long $timerTick, AnAction $action, AnActionEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$actionId, (String)"$actionId");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        LatencyRecorder.getInstance().recordLatencyAwareAction((Editor)this$0.editor, $actionId, $timerTick);
        $action.actionPerformed($event);
    }

    private static final void logThreadDump$lambda$20$lambda$19(RetypeSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logThreadDump();
    }

    static {
        Logger logger = Logger.getInstance(RetypeSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(RetypeSession::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/retype/RetypeSession$Companion;", "", "()V", "INTERFERE_FILE_NAME", "", "LARGE_INDEX_DIR_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

