/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.internal.statistic.FavoriteTypeValidationRule;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.TreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/BookmarkUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "bookmarksTotal", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "bookmarksWithLetter", "bookmarksWithLine", "bookmarksWithNumber", "favoriteCustom", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "favoriteDirectories", "favoriteFiles", "favoritesLists", "favoritesTotal", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBookmarkUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkUsagesCollector.kt\ncom/intellij/internal/statistic/BookmarkUsagesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,102:1\n766#2:103\n857#2,2:104\n766#2:106\n857#2,2:107\n766#2:109\n857#2,2:110\n361#3,7:112\n*S KotlinDebug\n*F\n+ 1 BookmarkUsagesCollector.kt\ncom/intellij/internal/statistic/BookmarkUsagesCollector\n*L\n46#1:103\n46#1:104,2\n47#1:106\n47#1:107,2\n48#1:109\n48#1:110,2\n68#1:112,7\n*E\n"})
public final class BookmarkUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup group = new EventLogGroup("bookmarks", 2, null, 4, null);
    @NotNull
    private final EventId1<Integer> bookmarksTotal = this.group.registerEvent("bookmarks.total", (EventField)EventFields.Count);
    @NotNull
    private final EventId1<Integer> bookmarksWithLine = this.group.registerEvent("bookmarks.with.line", (EventField)EventFields.Count);
    @NotNull
    private final EventId1<Integer> bookmarksWithNumber = this.group.registerEvent("bookmarks.with.number.mnemonic", (EventField)EventFields.Count);
    @NotNull
    private final EventId1<Integer> bookmarksWithLetter = this.group.registerEvent("bookmarks.with.letter.mnemonic", (EventField)EventFields.Count);
    @NotNull
    private final EventId1<Integer> favoritesLists = this.group.registerEvent("favorites.lists", (EventField)EventFields.Count);
    @NotNull
    private final EventId1<Integer> favoritesTotal = this.group.registerEvent("favorites.total", (EventField)EventFields.Count);
    @NotNull
    private final EventId1<Integer> favoriteFiles = this.group.registerEvent("favorites.files", (EventField)EventFields.Count);
    @NotNull
    private final EventId1<Integer> favoriteDirectories = this.group.registerEvent("favorites.directories", (EventField)EventFields.Count);
    @NotNull
    private final EventId3<Integer, String, Object> favoriteCustom = this.group.registerEvent("favorites.custom", (EventField)EventFields.Count, (EventField)EventFields.StringValidatedByCustomRule((String)"type", FavoriteTypeValidationRule.class), (EventField)EventFields.PluginInfoFromInstance);

    @NotNull
    public EventLogGroup getGroup() {
        return this.group;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        char c2;
        boolean bl;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Set result2 = new LinkedHashSet();
        BookmarkManager bookmarkManager = BookmarkManager.getInstance(project2);
        if (bookmarkManager == null) {
            return result2;
        }
        BookmarkManager bookmarkManager2 = bookmarkManager;
        Collection<Bookmark> collection = bookmarkManager2.getAllBookmarks();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"bookmarkManager.allBookmarks");
        Collection<Bookmark> bookmarks = collection;
        ((Collection)result2).add(this.bookmarksTotal.metric((Object)bookmarks.size()));
        Collection collection2 = result2;
        Iterable iterable = bookmarks;
        EventId1<Integer> eventId1 = this.bookmarksWithLine;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Bookmark entry = (Bookmark)element$iv$iv;
            bl = false;
            if (!entry.hasLine()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection2.add(eventId1.metric((Object)((List)destination$iv$iv).size()));
        collection2 = result2;
        $this$filter$iv = bookmarks;
        eventId1 = this.bookmarksWithNumber;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Bookmark bookmark = (Bookmark)element$iv$iv;
            bl = false;
            c2 = bookmark.getMnemonic();
            boolean bl2 = '0' <= c2 ? c2 < ':' : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection2.add(eventId1.metric((Object)((List)destination$iv$iv).size()));
        collection2 = result2;
        $this$filter$iv = bookmarks;
        eventId1 = this.bookmarksWithLetter;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Bookmark bookmark = (Bookmark)element$iv$iv;
            bl = false;
            c2 = bookmark.getMnemonic();
            boolean bl3 = 'A' <= c2 ? c2 < '[' : false;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection2.add(eventId1.metric((Object)((List)destination$iv$iv).size()));
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        List<String> list2 = favoritesManager.getAvailableFavoritesListNames();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"favoritesManager.availableFavoritesListNames");
        List<String> listNames = list2;
        ((Collection)result2).add(this.favoritesLists.metric((Object)listNames.size()));
        int favTotal = 0;
        int favFiles = 0;
        int favDirectories = 0;
        Map favCustom = new LinkedHashMap();
        Map favCustomProviders = new LinkedHashMap();
        for (String string2 : listNames) {
            List<TreeItem<Pair<AbstractUrl, String>>> urls;
            Intrinsics.checkNotNullExpressionValue(favoritesManager.getFavoritesListRootUrls(string2), (String)"favoritesManager.getFavo\u2026tesListRootUrls(listName)");
            favTotal += urls.size();
            for (TreeItem<Pair<AbstractUrl, String>> url : urls) {
                FavoriteNodeProvider favoriteNodeProvider;
                Object object;
                String type;
                AbstractUrl abstractUrl = (AbstractUrl)url.getData().first;
                if (abstractUrl instanceof PsiFileUrl) {
                    ++favFiles;
                    continue;
                }
                if (abstractUrl instanceof DirectoryUrl) {
                    ++favDirectories;
                    continue;
                }
                if (!(abstractUrl instanceof AbstractUrlFavoriteAdapter)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((AbstractUrlFavoriteAdapter)abstractUrl).getNodeProvider().getFavoriteTypeId(), (String)"abstractUrl.nodeProvider.favoriteTypeId");
                Map $this$getOrPut$iv = favCustom;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(type);
                if (value$iv == null) {
                    boolean bl4 = false;
                    Integer answer$iv = 0;
                    $this$getOrPut$iv.put(type, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                int count2 = ((Number)object).intValue();
                favCustom.put(type, count2 + 1);
                Map map2 = favCustomProviders;
                Intrinsics.checkNotNullExpressionValue((Object)((AbstractUrlFavoriteAdapter)abstractUrl).getNodeProvider(), (String)"abstractUrl.nodeProvider");
                map2.put(type, favoriteNodeProvider);
            }
        }
        ((Collection)result2).add(this.favoritesTotal.metric((Object)favTotal));
        ((Collection)result2).add(this.favoriteFiles.metric((Object)favFiles));
        ((Collection)result2).add(this.favoriteDirectories.metric((Object)favDirectories));
        for (Map.Entry entry : favCustom.entrySet()) {
            String type = (String)entry.getKey();
            int count3 = ((Number)entry.getValue()).intValue();
            Collection collection3 = result2;
            Integer n = count3;
            Object v = favCustomProviders.get(type);
            Intrinsics.checkNotNull(v);
            collection3.add(this.favoriteCustom.metric((Object)n, (Object)type, v));
        }
        return result2;
    }
}

