/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class IntentionsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("intentions", 58);
    private static final EventId3<Class<?>, PluginInfo, Language> CALLED = GROUP.registerEvent("called", (EventField)EventFields.Class((String)"id"), (EventField)EventFields.PluginInfo, (EventField)EventFields.Language);
    private static final EventId3<Class<?>, PluginInfo, Language> SHOWN = GROUP.registerEvent("shown", (EventField)EventFields.Class((String)"id"), (EventField)EventFields.PluginInfo, (EventField)EventFields.Language);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void record(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull Language language) {
        if (project2 == null) {
            IntentionsCollector.$$$reportNull$$$0(0);
        }
        if (action2 == null) {
            IntentionsCollector.$$$reportNull$$$0(1);
        }
        if (language == null) {
            IntentionsCollector.$$$reportNull$$$0(2);
        }
        IntentionsCollector.recordIntentionEvent(project2, action2, language, CALLED);
    }

    private static void recordIntentionEvent(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull Language language, EventId3<Class<?>, PluginInfo, Language> eventId) {
        if (project2 == null) {
            IntentionsCollector.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            IntentionsCollector.$$$reportNull$$$0(4);
        }
        if (language == null) {
            IntentionsCollector.$$$reportNull$$$0(5);
        }
        Class<?> clazz = IntentionsCollector.getOriginalHandlerClass(action2);
        PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(clazz);
        eventId.log(project2, clazz, (Object)info2, (Object)language);
        if (eventId == CALLED) {
            FeatureUsageTracker.getInstance().triggerFeatureUsedByIntention(clazz);
        }
    }

    @NotNull
    private static Class<?> getOriginalHandlerClass(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionsCollector.$$$reportNull$$$0(6);
        }
        FileModifier handler2 = action2;
        if (action2 instanceof IntentionActionDelegate) {
            IntentionAction delegate2 = ((IntentionActionDelegate)((Object)action2)).getDelegate();
            if (delegate2 != action2) {
                return IntentionsCollector.getOriginalHandlerClass(delegate2);
            }
        } else if (action2 instanceof QuickFixWrapper) {
            handler2 = ((QuickFixWrapper)action2).getFix();
        }
        Class<?> clazz = handler2.getClass();
        if (clazz == null) {
            IntentionsCollector.$$$reportNull$$$0(7);
        }
        return clazz;
    }

    public static void reportShownIntentions(@NotNull Project project2, ListPopup popup2, @NotNull Language language) {
        if (project2 == null) {
            IntentionsCollector.$$$reportNull$$$0(8);
        }
        if (language == null) {
            IntentionsCollector.$$$reportNull$$$0(9);
        }
        List values2 = popup2.getListStep().getValues();
        for (IntentionActionWithTextCaching value : values2) {
            IntentionsCollector.recordIntentionEvent(project2, value.getAction(), language, SHOWN);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/IntentionsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/IntentionsCollector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalHandlerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "recordIntentionEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalHandlerClass";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportShownIntentions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }
}

