/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.tools;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.collectors.fus.PluginInfoValidationRule;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.impl.OpenFilesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.search.scope.GeneratedFilesScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.ProjectProductionScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionsUsagesCollector
extends ProjectUsagesCollector {
    private static final Predicate<ScopeToolState> ENABLED = state -> !state.getTool().isEnabledByDefault() && state.isEnabled();
    private static final Predicate<ScopeToolState> DISABLED = state -> state.getTool().isEnabledByDefault() && !state.isEnabled();
    private static final List<String> ALLOWED_SCOPES = List.of("custom", CustomScopesProviderEx.getAllScope().getScopeId(), ProjectFilesScope.INSTANCE.getScopeId(), "Non-Project Files", ProjectProductionScope.INSTANCE.getScopeId(), "Tests", OpenFilesScope.INSTANCE.getScopeId(), GeneratedFilesScope.INSTANCE.getScopeId(), "Scratches and Consoles");
    private static final List<String> ALLOWED_SEVERITIES = ContainerUtil.concat(List.of("custom", "TYPO"), ContainerUtil.map(HighlightSeverity.DEFAULT_SEVERITIES, severity -> severity.getName()));
    private static final StringEventField INSPECTION_ID_FIELD = EventFields.StringValidatedByCustomRule((String)"inspection_id", InspectionToolValidator.class);
    private static final StringEventField SCOPE_FIELD = EventFields.String((String)"scope", ALLOWED_SCOPES);
    private static final StringEventField SEVERITY_FIELD = EventFields.String((String)"severity", ALLOWED_SEVERITIES);
    private static final BooleanEventField ENABLED_FIELD = EventFields.Boolean((String)"enabled");
    private static final BooleanEventField INSPECTION_ENABLED_FIELD = EventFields.Boolean((String)"inspection_enabled");
    private static final PrimitiveEventField<Object> OPTION_VALUE_FIELD = new PrimitiveEventField<Object>(){

        @NotNull
        public List<String> getValidationRule() {
            List<String> list2 = Arrays.asList("{enum#boolean}", "{regexp#integer}");
            if (list2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void addData(@NotNull FeatureUsageData fuData, Object value) {
            if (fuData == null) {
                1.$$$reportNull$$$0(1);
            }
            if (value instanceof Integer) {
                fuData.addData(this.getName(), ((Integer)value).intValue());
            } else if (value instanceof Boolean) {
                fuData.addData(this.getName(), ((Boolean)value).booleanValue());
            }
        }

        @NotNull
        public String getName() {
            return "option_value";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fuData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidationRule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1 -> new IllegalArgumentException(string2);
            };
        }
    };
    private static final StringEventField OPTION_TYPE_FIELD = new StringEventField.ValidatedByAllowedValues("option_type", Arrays.asList("boolean", "integer"));
    private static final StringEventField OPTION_NAME_FIELD = EventFields.StringValidatedByCustomRule((String)"option_name", PluginInfoValidationRule.class);
    private static final EventLogGroup GROUP = new EventLogGroup("inspections", 13);
    private static final VarargEventId NOT_DEFAULT_STATE = GROUP.registerVarargEvent("not.default.state", new EventField[]{INSPECTION_ID_FIELD, EventFields.Language, ENABLED_FIELD, EventFields.PluginInfo});
    private static final VarargEventId SETTING_NON_DEFAULT_STATE = GROUP.registerVarargEvent("setting.non.default.state", new EventField[]{INSPECTION_ID_FIELD, INSPECTION_ENABLED_FIELD, EventFields.PluginInfo, OPTION_TYPE_FIELD, OPTION_VALUE_FIELD, OPTION_NAME_FIELD});
    private static final EventId1<Integer> PROFILES = GROUP.registerEvent("profiles", (EventField)EventFields.Int((String)"amount"));
    private static final EventId3<Boolean, Boolean, Boolean> PROFILE = GROUP.registerEvent("used.profile", (EventField)EventFields.Boolean((String)"project_level"), (EventField)EventFields.Boolean((String)"default"), (EventField)EventFields.Boolean((String)"locked"));
    private static final VarargEventId NOT_DEFAULT_SCOPE_AND_SEVERITY = GROUP.registerVarargEvent("not.default.scope.and.severity", new EventField[]{INSPECTION_ID_FIELD, SCOPE_FIELD, SEVERITY_FIELD, EventFields.PluginInfo});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project2) {
        if (project2 == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project2);
        result2.add(PROFILES.metric((Object)profileManager.getProfiles().size()));
        InspectionProfileImpl profile = profileManager.getCurrentProfile();
        result2.add(InspectionsUsagesCollector.create(profile));
        List<ScopeToolState> tools = profile.getAllTools();
        for (ScopeToolState state : tools) {
            InspectionToolWrapper<?, ?> tool = state.getTool();
            PluginInfo pluginInfo = InspectionsUsagesCollector.getInfo(tool);
            if (ENABLED.test(state)) {
                result2.add(InspectionsUsagesCollector.create(tool, pluginInfo, true));
            } else if (DISABLED.test(state)) {
                result2.add(InspectionsUsagesCollector.create(tool, pluginInfo, false));
            }
            result2.addAll(InspectionsUsagesCollector.getChangedSettingsEvents(tool, pluginInfo, state.isEnabled()));
            MetricEvent scopeAndSeverityEvent = InspectionsUsagesCollector.getChangedScopeAndSeverityEvent(state, pluginInfo);
            if (scopeAndSeverityEvent == null) continue;
            result2.add(scopeAndSeverityEvent);
        }
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static Collection<MetricEvent> getChangedSettingsEvents(InspectionToolWrapper<?, ?> tool, PluginInfo pluginInfo, boolean inspectionEnabled) {
        if (!InspectionsUsagesCollector.isSafeToReport(pluginInfo)) {
            return Collections.emptyList();
        }
        if (!tool.isInitialized()) {
            return Collections.emptyList();
        }
        Object entry = tool.getTool();
        Map<String, Attribute> options2 = InspectionsUsagesCollector.getOptions(entry);
        if (options2.isEmpty()) {
            return Collections.emptyList();
        }
        Set<String> fields = ContainerUtil.map2Set(ReflectionUtil.collectFields(entry.getClass()), f -> f.getName());
        Map<String, Attribute> defaultOptions = InspectionsUsagesCollector.getOptions((InspectionProfileEntry)ReflectionUtil.newInstance(entry.getClass()));
        ArrayList<MetricEvent> result2 = new ArrayList<MetricEvent>();
        String inspectionId = tool.getID();
        for (Map.Entry<String, Attribute> option : options2.entrySet()) {
            Pair<EventPair<String>, EventPair<Object>> settingPair;
            Attribute defaultValue;
            String name = option.getKey();
            Attribute value = option.getValue();
            if (!fields.contains(name) || value == null || (defaultValue = defaultOptions.get(name)) != null && StringUtil.equals(value.getValue(), defaultValue.getValue()) || (settingPair = InspectionsUsagesCollector.getSettingValue(value)) == null) continue;
            result2.add(SETTING_NON_DEFAULT_STATE.metric(new EventPair[]{INSPECTION_ID_FIELD.with((Object)inspectionId), INSPECTION_ENABLED_FIELD.with((Object)inspectionEnabled), EventFields.PluginInfo.with((Object)pluginInfo), (EventPair)settingPair.first, (EventPair)settingPair.second, OPTION_NAME_FIELD.with((Object)name)}));
        }
        return result2;
    }

    private static Pair<EventPair<String>, EventPair<Object>> getSettingValue(Attribute value) {
        try {
            boolean booleanValue = value.getBooleanValue();
            return new Pair<EventPair<String>, EventPair<Object>>(OPTION_TYPE_FIELD.with((Object)"boolean"), OPTION_VALUE_FIELD.with((Object)booleanValue));
        }
        catch (DataConversionException e1) {
            try {
                int intValue = value.getIntValue();
                return new Pair<EventPair<String>, EventPair<Object>>(OPTION_TYPE_FIELD.with((Object)"integer"), OPTION_VALUE_FIELD.with((Object)intValue));
            }
            catch (DataConversionException e2) {
                return null;
            }
        }
    }

    @NotNull
    private static MetricEvent create(InspectionToolWrapper<?, ?> tool, PluginInfo info2, boolean enabled) {
        MetricEvent metricEvent = NOT_DEFAULT_STATE.metric(new EventPair[]{INSPECTION_ID_FIELD.with((Object)(InspectionsUsagesCollector.isSafeToReport(info2) ? tool.getID() : "third.party")), EventFields.Language.with((Object)Language.findLanguageByID(tool.getLanguage())), ENABLED_FIELD.with((Object)enabled), EventFields.PluginInfo.with((Object)info2)});
        if (metricEvent == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(2);
        }
        return metricEvent;
    }

    @NotNull
    private static MetricEvent create(InspectionProfileImpl profile) {
        MetricEvent metricEvent = PROFILE.metric((Object)profile.isProjectLevel(), (Object)profile.toString().equals(profile.isProjectLevel() ? "Project Default" : "Default"), (Object)profile.isProfileLocked());
        if (metricEvent == null) {
            InspectionsUsagesCollector.$$$reportNull$$$0(3);
        }
        return metricEvent;
    }

    private static boolean isSafeToReport(PluginInfo info2) {
        return info2 != null && info2.isSafeToReport();
    }

    @Nullable
    private static PluginInfo getInfo(InspectionToolWrapper<?, ?> tool) {
        Object extension2 = tool.getExtension();
        PluginDescriptor pluginDescriptor = extension2 == null ? null : ((BaseKeyedLazyInstance)extension2).getPluginDescriptor();
        return pluginDescriptor != null ? PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor) : null;
    }

    private static Map<String, Attribute> getOptions(InspectionProfileEntry entry) {
        Element element = new Element("options");
        try {
            ScopeToolState.tryWriteSettings(entry, element);
            List<Content> options2 = element.getContent();
            if (options2.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, Attribute> set2 = new HashMap<String, Attribute>(options2.size());
            for (Content option : options2) {
                if (!(option instanceof Element)) continue;
                Element el = (Element)option;
                Attribute nameAttr = el.getAttribute("name");
                Attribute valueAttr = el.getAttribute("value");
                if (nameAttr == null || valueAttr == null) continue;
                set2.put(nameAttr.getValue(), valueAttr);
            }
            return set2;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    @Nullable
    private static MetricEvent getChangedScopeAndSeverityEvent(ScopeToolState tool, PluginInfo info2) {
        if (!InspectionsUsagesCollector.isSafeToReport(info2)) {
            return null;
        }
        if (!tool.getScopeName().equals(CustomScopesProviderEx.getAllScope().getScopeId()) || !tool.getLevel().getSeverity().getName().equals(tool.getTool().getDefaultLevel().getSeverity().getName())) {
            String scopeId = tool.getScopeName();
            String severity = tool.getLevel().getName();
            return NOT_DEFAULT_SCOPE_AND_SEVERITY.metric(new EventPair[]{INSPECTION_ID_FIELD.with((Object)(InspectionsUsagesCollector.isSafeToReport(info2) ? tool.getTool().getID() : "third.party")), SCOPE_FIELD.with((Object)(ALLOWED_SCOPES.contains(scopeId) ? scopeId : "custom")), SEVERITY_FIELD.with((Object)(ALLOWED_SEVERITIES.contains(severity) ? severity : "custom")), EventFields.PluginInfo.with((Object)info2)});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }

    public static class InspectionToolValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "tool";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                InspectionToolValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                InspectionToolValidator.$$$reportNull$$$0(1);
            }
            if (InspectionToolValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    InspectionToolValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = InspectionToolValidator.acceptWhenReportedByPluginFromPluginRepository((EventContext)context2);
            if (validationResultType == null) {
                InspectionToolValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector$InspectionToolValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/tools/InspectionsUsagesCollector$InspectionToolValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

