/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Annotation
implements Segment {
    private final int myStartOffset;
    private final int myEndOffset;
    private final HighlightSeverity mySeverity;
    private final @NlsContexts.DetailedDescription String myMessage;
    private ProblemHighlightType myHighlightType;
    private TextAttributesKey myEnforcedAttributesKey;
    private TextAttributes myEnforcedAttributes;
    private List<QuickFixInfo> myQuickFixes;
    private Boolean myNeedsUpdateOnTyping;
    private @NlsContexts.Tooltip String myTooltip;
    private boolean myAfterEndOfLine;
    private boolean myIsFileLevelAnnotation;
    private GutterIconRenderer myGutterIconRenderer;
    @Nullable
    private ProblemGroup myProblemGroup;
    private List<QuickFixInfo> myBatchFixes;
    private PsiReference unresolvedReference;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public Annotation(int startOffset, int endOffset, @NotNull HighlightSeverity severity, @NlsContexts.DetailedDescription String message, @NlsContexts.Tooltip String tooltip) {
        if (severity == null) {
            Annotation.$$$reportNull$$$0(0);
        }
        this.myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        assert (startOffset <= endOffset) : startOffset + ":" + endOffset;
        assert (startOffset >= 0) : "Start offset must not be negative: " + startOffset;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myMessage = message;
        this.myTooltip = tooltip;
        this.mySeverity = severity;
    }

    @Deprecated
    public void registerFix(@NotNull IntentionAction fix2) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(1);
        }
        this.registerFix(fix2, null);
    }

    @Deprecated
    public void registerFix(@NotNull IntentionAction fix2, TextRange range) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(2);
        }
        this.registerFix(fix2, range, null);
    }

    @Deprecated
    public void registerFix(@NotNull LocalQuickFix fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(3);
        }
        if (problemDescriptor == null) {
            Annotation.$$$reportNull$$$0(4);
        }
        range = this.notNullize(range);
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(new LocalQuickFixAsIntentionAdapter(fix2, problemDescriptor), range, key));
    }

    @Deprecated
    public void registerFix(@NotNull IntentionAction fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(5);
        }
        range = this.notNullize(range);
        List<QuickFixInfo> fixes = this.myQuickFixes;
        if (fixes == null) {
            this.myQuickFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(fix2, range, key));
    }

    @NotNull
    private TextRange notNullize(@Nullable TextRange range) {
        TextRange textRange = range == null ? new TextRange(this.myStartOffset, this.myEndOffset) : range;
        if (textRange == null) {
            Annotation.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @Deprecated
    public <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull T fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(7);
        }
        range = this.notNullize(range);
        List<QuickFixInfo> fixes = this.myBatchFixes;
        if (fixes == null) {
            this.myBatchFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(fix2, range, key));
    }

    @Deprecated
    public <T extends IntentionAction & LocalQuickFix> void registerUniversalFix(@NotNull T fix2, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix2 == null) {
            Annotation.$$$reportNull$$$0(8);
        }
        this.registerBatchFix(fix2, range, key);
        this.registerFix(fix2, range, key);
    }

    @Deprecated
    public void setNeedsUpdateOnTyping(boolean b) {
        this.myNeedsUpdateOnTyping = b;
    }

    public boolean needsUpdateOnTyping() {
        if (this.myNeedsUpdateOnTyping == null) {
            return this.mySeverity != HighlightSeverity.INFORMATION;
        }
        return this.myNeedsUpdateOnTyping;
    }

    @Override
    public int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            Annotation.$$$reportNull$$$0(9);
        }
        return highlightSeverity;
    }

    @NotNull
    public ProblemHighlightType getHighlightType() {
        ProblemHighlightType problemHighlightType = this.myHighlightType;
        if (problemHighlightType == null) {
            Annotation.$$$reportNull$$$0(10);
        }
        return problemHighlightType;
    }

    @NotNull
    public TextAttributesKey getTextAttributes() {
        if (this.myEnforcedAttributesKey != null) {
            TextAttributesKey textAttributesKey = this.myEnforcedAttributesKey;
            if (textAttributesKey == null) {
                Annotation.$$$reportNull$$$0(11);
            }
            return textAttributesKey;
        }
        TextAttributesKey textAttributesKey = switch (this.myHighlightType) {
            case ProblemHighlightType.GENERIC_ERROR_OR_WARNING -> {
                if (this.mySeverity == HighlightSeverity.ERROR) {
                    yield CodeInsightColors.ERRORS_ATTRIBUTES;
                }
                if (this.mySeverity == HighlightSeverity.WARNING) {
                    yield CodeInsightColors.WARNINGS_ATTRIBUTES;
                }
                if (this.mySeverity == HighlightSeverity.WEAK_WARNING) {
                    yield CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                }
                yield HighlighterColors.NO_HIGHLIGHTING;
            }
            case ProblemHighlightType.GENERIC_ERROR -> CodeInsightColors.ERRORS_ATTRIBUTES;
            case ProblemHighlightType.LIKE_DEPRECATED -> CodeInsightColors.DEPRECATED_ATTRIBUTES;
            case ProblemHighlightType.LIKE_UNUSED_SYMBOL -> CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
            case ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, ProblemHighlightType.ERROR -> CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES;
            default -> HighlighterColors.NO_HIGHLIGHTING;
        };
        if (textAttributesKey == null) {
            Annotation.$$$reportNull$$$0(12);
        }
        return textAttributesKey;
    }

    public TextAttributes getEnforcedTextAttributes() {
        return this.myEnforcedAttributes;
    }

    @Deprecated
    public void setEnforcedTextAttributes(TextAttributes enforcedAttributes) {
        this.myEnforcedAttributes = enforcedAttributes;
    }

    @Nullable
    public List<QuickFixInfo> getQuickFixes() {
        return this.myQuickFixes;
    }

    @Nullable
    public List<QuickFixInfo> getBatchFixes() {
        return this.myBatchFixes;
    }

    @NlsContexts.DetailedDescription
    public String getMessage() {
        return this.myMessage;
    }

    @NlsContexts.Tooltip
    public String getTooltip() {
        return this.myTooltip;
    }

    @Deprecated
    public void setTooltip(@NlsContexts.Tooltip String tooltip) {
        this.myTooltip = tooltip;
    }

    @Deprecated
    public void setHighlightType(@NotNull ProblemHighlightType highlightType) {
        if (highlightType == null) {
            Annotation.$$$reportNull$$$0(13);
        }
        this.myHighlightType = highlightType;
    }

    @Deprecated
    public void setTextAttributes(TextAttributesKey enforcedAttributes) {
        this.myEnforcedAttributesKey = enforcedAttributes;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    @Deprecated
    public void setAfterEndOfLine(boolean afterEndOfLine) {
        this.myAfterEndOfLine = afterEndOfLine;
    }

    public boolean isFileLevelAnnotation() {
        return this.myIsFileLevelAnnotation;
    }

    @Deprecated
    public void setFileLevelAnnotation(boolean isFileLevelAnnotation) {
        this.myIsFileLevelAnnotation = isFileLevelAnnotation;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Deprecated
    public void setGutterIconRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @Deprecated
    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    @NonNls
    public String toString() {
        return "Annotation(message='" + this.myMessage + "', severity='" + this.mySeverity + "', toolTip='" + this.myTooltip + "')";
    }

    @Deprecated
    @ApiStatus.Internal
    public void setUnresolvedReference(PsiReference reference2) {
        this.unresolvedReference = reference2;
    }

    @Deprecated
    @ApiStatus.Internal
    public PsiReference getUnresolvedReference() {
        return this.unresolvedReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/annotation/Annotation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/annotation/Annotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerBatchFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerUniversalFix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightType";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 9, 10, 11, 12 -> new IllegalStateException(string2);
        };
    }

    public static class QuickFixInfo {
        @NotNull
        public final IntentionAction quickFix;
        @NotNull
        public final TextRange textRange;
        public final HighlightDisplayKey key;

        QuickFixInfo(@NotNull IntentionAction fix2, @NotNull TextRange range, @Nullable HighlightDisplayKey key) {
            if (fix2 == null) {
                QuickFixInfo.$$$reportNull$$$0(0);
            }
            if (range == null) {
                QuickFixInfo.$$$reportNull$$$0(1);
            }
            this.key = key;
            this.quickFix = fix2;
            this.textRange = range;
        }

        public String toString() {
            return this.quickFix.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/annotation/Annotation$QuickFixInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

