/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.lang.customFolding.CustomFoldingRegionsPopup;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoCustomRegionAction
extends AnAction
implements DumbAware,
PopupAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (Boolean.TRUE.equals(e.getData(PlatformCoreDataKeys.IS_MODAL_CONTEXT))) {
            return;
        }
        if (project2 != null && editor2 != null) {
            if (DumbService.getInstance(project2).isDumb()) {
                DumbService.getInstance(project2).showDumbModeNotification(IdeBundle.message((String)"goto.custom.region.message.dumb.mode", (Object[])new Object[0]));
                return;
            }
            CommandProcessor processor = CommandProcessor.getInstance();
            processor.executeCommand(project2, () -> {
                Collection<FoldingDescriptor> foldingDescriptors = GotoCustomRegionAction.getCustomFoldingDescriptors(editor2, project2);
                if (foldingDescriptors.size() > 0) {
                    CustomFoldingRegionsPopup.show(foldingDescriptors, editor2, project2);
                } else {
                    GotoCustomRegionAction.notifyCustomRegionsUnavailable(editor2, project2);
                }
            }, IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0]), null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        presentation2.setText(IdeBundle.messagePointer((String)"goto.custom.region.menu.item", (Object[])new Object[0]));
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project2 = e.getProject();
        boolean isAvailable = editor2 != null && project2 != null;
        presentation2.setEnabledAndVisible(isAvailable);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    private static Collection<FoldingDescriptor> getCustomFoldingDescriptors(@NotNull Editor editor2, @NotNull Project project2) {
        PsiFile file2;
        if (editor2 == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(4);
        }
        HashSet<FoldingDescriptor> foldingDescriptors = new HashSet<FoldingDescriptor>();
        Document document = editor2.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        PsiFile psiFile = file2 = documentManager != null ? documentManager.getPsiFile(document) : null;
        if (file2 != null) {
            FileViewProvider viewProvider = file2.getViewProvider();
            for (Language language : viewProvider.getLanguages()) {
                PsiFile psi = viewProvider.getPsi(language);
                FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
                if (psi == null) continue;
                for (FoldingDescriptor descriptor2 : LanguageFolding.buildFoldingDescriptors(foldingBuilder, psi, document, false)) {
                    CustomFoldingBuilder customFoldingBuilder = GotoCustomRegionAction.getCustomFoldingBuilder(foldingBuilder, descriptor2);
                    if (customFoldingBuilder == null || !customFoldingBuilder.isCustomRegionStart(descriptor2.getElement())) continue;
                    foldingDescriptors.add(descriptor2);
                }
            }
        }
        HashSet<FoldingDescriptor> hashSet = foldingDescriptors;
        if (hashSet == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Nullable
    private static CustomFoldingBuilder getCustomFoldingBuilder(FoldingBuilder builder2, FoldingDescriptor descriptor2) {
        if (builder2 instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)builder2;
        }
        FoldingBuilder originalBuilder = CompositeFoldingBuilder.getOriginalBuilder(descriptor2);
        if (originalBuilder instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)originalBuilder;
        }
        return null;
    }

    private static void notifyCustomRegionsUnavailable(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(7);
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        Balloon balloon = popupFactory.createHtmlTextBalloonBuilder(IdeBundle.message((String)"goto.custom.region.message.unavailable", (Object[])new Object[0]), MessageType.INFO, null).setFadeoutTime(2000L).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon();
        Disposer.register(project2, (Disposable)balloon);
        balloon.show(popupFactory.guessBestPopupLocation(editor2), Balloon.Position.below);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/customFolding/GotoCustomRegionAction";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/customFolding/GotoCustomRegionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFoldingDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCustomFoldingDescriptors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyCustomRegionsUnavailable";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5 -> new IllegalStateException(string2);
        };
    }
}

