/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.lang.LangBundle;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.openapi.util.text.StringUtil;

public class VisualStudioCustomFoldingProvider
extends CustomFoldingProvider {
    @Override
    public boolean isCustomRegionStart(String elementText) {
        return elementText.contains("region") && elementText.matches("[/*#-]*\\s*region.*");
    }

    @Override
    public boolean isCustomRegionEnd(String elementText) {
        return elementText.contains("endregion") && elementText.matches("[/*#-]*\\s*endregion.*");
    }

    @Override
    public String getPlaceholderText(String elementText) {
        String textAfterMarker = elementText.replaceFirst("[/*#-]*\\s*region(.*)", "$1");
        String result2 = elementText.startsWith("/*") ? StringUtil.trimEnd(textAfterMarker, "*/").trim() : textAfterMarker.trim();
        return result2.isEmpty() ? "..." : result2;
    }

    @Override
    public String getDescription() {
        return LangBundle.message("custom.folding.comments.vs.description", new Object[0]);
    }

    @Override
    public String getStartString() {
        return "region ?";
    }

    @Override
    public String getEndString() {
        return "endregion";
    }
}

