/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide;

import com.intellij.lang.documentation.ide.impl.DocumentationBrowser;
import com.intellij.lang.documentation.ide.ui.DocumentationUI;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.impl.DocumentationRequest;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.util.ui.EDT;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\r"}, d2={"documentationComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "targetPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "targetPresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "request", "Lcom/intellij/platform/backend/documentation/impl/DocumentationRequest;", "intellij.platform.lang.impl"})
@JvmName(name="DocumentationUtil")
public final class DocumentationUtil {
    @ApiStatus.Experimental
    @NotNull
    public static final JComponent documentationComponent(@NotNull Project project2, @NotNull Pointer<? extends DocumentationTarget> targetPointer, @NotNull TargetPresentation targetPresentation2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(targetPointer, (String)"targetPointer");
        Intrinsics.checkNotNullParameter((Object)targetPresentation2, (String)"targetPresentation");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        EDT.assertIsEdt();
        DocumentationRequest request2 = new DocumentationRequest(targetPointer, targetPresentation2);
        return DocumentationUtil.documentationComponent(project2, request2, parentDisposable);
    }

    @NotNull
    public static final JComponent documentationComponent(@NotNull Project project2, @NotNull DocumentationRequest request2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        DocumentationBrowser browser = DocumentationBrowser.Companion.createBrowser(project2, request2);
        DocumentationUI ui = new DocumentationUI(project2, browser);
        Disposer.register(parentDisposable, ui);
        return ui.getScrollPane();
    }
}

