/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.actions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.documentation.ide.IdeDocumentationTargetProvider;
import com.intellij.lang.documentation.ide.impl.DocumentationBrowser;
import com.intellij.lang.documentation.ide.impl.DocumentationHistory;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.lang.documentation.symbol.impl.DefaultTargetSymbolDocumentationTargetProviderKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001e\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u00112\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0000\u001a\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a(\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"DOCUMENTATION_POPUP", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "getDOCUMENTATION_POPUP", "()Lcom/intellij/openapi/actionSystem/DataKey;", "PRIMARY_GROUP_ID", "", "TOGGLE_AUTO_SHOW_ACTION_ID", "TOGGLE_AUTO_UPDATE_ACTION_ID", "TOGGLE_SHOW_IN_POPUP_ACTION_ID", "documentationBrowser", "Lcom/intellij/lang/documentation/ide/impl/DocumentationBrowser;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "documentationHistory", "Lcom/intellij/lang/documentation/ide/impl/DocumentationHistory;", "documentationTargetsInner", "", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "groupActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "groupId", "navigationActions", "primaryActions", "registerBackForwardActions", "", "component", "Ljavax/swing/JComponent;", "targetsFromEditor", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "intellij.platform.lang.impl"})
public final class ActionsKt {
    @NotNull
    private static final DataKey<JBPopup> DOCUMENTATION_POPUP;
    @NotNull
    public static final String PRIMARY_GROUP_ID = "Documentation.PrimaryGroup";
    @NotNull
    public static final String TOGGLE_SHOW_IN_POPUP_ACTION_ID = "Documentation.ToggleShowInPopup";
    @NotNull
    public static final String TOGGLE_AUTO_SHOW_ACTION_ID = "Documentation.ToggleAutoShow";
    @NotNull
    public static final String TOGGLE_AUTO_UPDATE_ACTION_ID = "Documentation.ToggleAutoUpdate";

    @NotNull
    public static final DataKey<JBPopup> getDOCUMENTATION_POPUP() {
        return DOCUMENTATION_POPUP;
    }

    @NotNull
    public static final List<AnAction> primaryActions() {
        return ActionsKt.groupActions(PRIMARY_GROUP_ID);
    }

    @NotNull
    public static final List<AnAction> navigationActions() {
        return ActionsKt.groupActions("Documentation.Navigation");
    }

    private static final List<AnAction> groupActions(String groupId) {
        ActionGroup actionGroup2 = ActionUtil.getActionGroup((String)groupId);
        if (actionGroup2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnAction[] anActionArray = actionGroup2.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"requireNotNull(ActionUti\u2026oupId)).getChildren(null)");
        AnAction[] anActionArray2 = anActionArray;
        return CollectionsKt.listOf((Object[])Arrays.copyOf(anActionArray2, anActionArray2.length));
    }

    public static final void registerBackForwardActions(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Shortcut[] shortcutArray = new Shortcut[]{(Shortcut)KeyboardShortcut.fromString((String)(ScreenReader.isActive() ? "alt LEFT" : "LEFT")), (Shortcut)KeymapUtil.parseMouseShortcut((String)"button4")};
        EmptyAction.registerWithShortcutSet((String)"Documentation.Back", (ShortcutSet)((ShortcutSet)new CustomShortcutSet(shortcutArray)), (JComponent)component2);
        shortcutArray = new Shortcut[]{(Shortcut)KeyboardShortcut.fromString((String)(ScreenReader.isActive() ? "alt RIGHT" : "RIGHT")), (Shortcut)KeymapUtil.parseMouseShortcut((String)"button5")};
        EmptyAction.registerWithShortcutSet((String)"Documentation.Forward", (ShortcutSet)((ShortcutSet)new CustomShortcutSet(shortcutArray)), (JComponent)component2);
    }

    private static final List<DocumentationTarget> documentationTargetsInner(DataProvider dataProvider) {
        List<DocumentationTarget> symbolTargets;
        List<DocumentationTarget> editorTargets;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataProvider);
        if (project2 == null) {
            return CollectionsKt.emptyList();
        }
        Project project3 = project2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataProvider);
        if (editor2 != null && (editorTargets = ActionsKt.targetsFromEditor(project3, editor2, editor2.getCaretModel().getOffset())) != null) {
            return editorTargets;
        }
        List symbols = (List)CommonDataKeys.SYMBOLS.getData(dataProvider);
        Collection collection = symbols;
        if (!(collection == null || collection.isEmpty()) && !((Collection)(symbolTargets = DefaultTargetSymbolDocumentationTargetProviderKt.symbolDocumentationTargets(project3, symbols))).isEmpty()) {
            return symbolTargets;
        }
        PsiElement targetElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataProvider);
        if (targetElement != null) {
            return CollectionsKt.listOf((Object)UtilKt.psiDocumentationTarget(targetElement, null));
        }
        return CollectionsKt.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public static final List<DocumentationTarget> targetsFromEditor(@NotNull Project project2, @NotNull Editor editor2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, project2);
        if (psiFile == null) {
            return null;
        }
        PsiFile file2 = psiFile;
        IdeDocumentationTargetProvider ideDocumentationTargetProvider = IdeDocumentationTargetProvider.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)ideDocumentationTargetProvider, (String)"getInstance(project)");
        IdeDocumentationTargetProvider ideTargetProvider = ideDocumentationTargetProvider;
        LookupEx lookup2 = LookupManager.getActiveLookup(editor2);
        if (lookup2 != null) {
            LookupElement lookupElement = lookup2.getCurrentItem();
            if (lookupElement == null) {
                return null;
            }
            LookupElement lookupElement2 = lookupElement;
            DocumentationTarget documentationTarget = ideTargetProvider.documentationTarget(editor2, file2, lookupElement2);
            if (documentationTarget == null) {
                return null;
            }
            DocumentationTarget target2 = documentationTarget;
            return CollectionsKt.listOf((Object)target2);
        }
        return (List)ContainerUtil.nullize((Collection)ideTargetProvider.documentationTargets(editor2, file2, offset2));
    }

    @Nullable
    public static final DocumentationHistory documentationHistory(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        DocumentationBrowser documentationBrowser = ActionsKt.documentationBrowser(dc);
        return documentationBrowser != null ? documentationBrowser.getHistory() : null;
    }

    @Nullable
    public static final DocumentationBrowser documentationBrowser(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        Object object = dc.getData(com.intellij.platform.ide.documentation.ActionsKt.DOCUMENTATION_BROWSER);
        return object instanceof DocumentationBrowser ? (DocumentationBrowser)object : null;
    }

    public static final /* synthetic */ List access$documentationTargetsInner(DataProvider dataProvider) {
        return ActionsKt.documentationTargetsInner(dataProvider);
    }

    static {
        DataKey dataKey = DataKey.create((String)"documentation.popup");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(\"documentation.popup\")");
        DOCUMENTATION_POPUP = dataKey;
    }
}

