/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.ui;

import com.intellij.lang.documentation.ide.ui.DocumentationUI;
import com.intellij.lang.documentation.ide.ui.SearchHighlighterPainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.EventListeners;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Highlighter;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\b\u0010$\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020 H\u0002J\b\u0010'\u001a\u00020 H\u0002J\b\u0010(\u001a\u00020 H\u0002J\b\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010+\u001a\u00020 H\u0002J\b\u0010,\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0012j\b\u0012\u0004\u0012\u00020\b`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR*\u0010\u001e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/lang/documentation/ide/ui/SearchModel;", "Lcom/intellij/openapi/Disposable;", "ui", "Lcom/intellij/lang/documentation/ide/ui/DocumentationUI;", "(Lcom/intellij/lang/documentation/ide/ui/DocumentationUI;)V", "cs", "Lkotlinx/coroutines/CoroutineScope;", "currentSelection", "", "editorPane", "Ljavax/swing/JEditorPane;", "hasNext", "", "getHasNext", "()Z", "hasPrev", "getHasPrev", "indices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "matchLabel", "Ljavax/swing/JLabel;", "getMatchLabel", "()Ljavax/swing/JLabel;", "pattern", "", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "tagHandles", "Lkotlin/Function0;", "", "createNavigationActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "near", "next", "prev", "removeHighlights", "scroll", "setPattern", "updateHighlighting", "updateIndices", "updateMatchLabel", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSearchModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchModel.kt\ncom/intellij/lang/documentation/ide/ui/SearchModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1#2:222\n2333#3,14:223\n*S KotlinDebug\n*F\n+ 1 SearchModel.kt\ncom/intellij/lang/documentation/ide/ui/SearchModel\n*L\n153#1:223,14\n*E\n"})
public final class SearchModel
implements Disposable {
    @NotNull
    private final JEditorPane editorPane;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final SearchTextField searchField;
    @NotNull
    private final JLabel matchLabel;
    @NotNull
    private String pattern;
    @NotNull
    private final ArrayList<Integer> indices;
    private int currentSelection;
    @NotNull
    private final ArrayList<Function0<Unit>> tagHandles;

    /*
     * WARNING - void declaration
     */
    public SearchModel(@NotNull DocumentationUI ui) {
        void label2;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.editorPane = ui.getEditorPane();
        this.cs = CoroutineScopeKt.CoroutineScope(CoroutinesKt.getEDT(Dispatchers.INSTANCE));
        this.searchField = new SearchTextField();
        JLabel jLabel2 = jLabel = new JLabel();
        SearchModel searchModel = this;
        boolean bl = false;
        label2.setFont(JBUI.Fonts.toolbarFont());
        label2.setText("9888 results");
        label2.setPreferredSize(label2.getPreferredSize());
        label2.setText(null);
        label2.setHorizontalAlignment(4);
        searchModel.matchLabel = jLabel;
        this.searchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String pattern = this.getSearchField().getText();
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pattern");
                this.setPattern(pattern);
                this.near();
            }
        });
        this.searchField.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 && this.getHasNext()) {
                    this.next();
                }
            }
        });
        BuildersKt.launch$default(this.cs, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ui, this, null){
            int label;
            final /* synthetic */ DocumentationUI $ui;
            final /* synthetic */ SearchModel this$0;
            {
                this.$ui = $ui;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$ui.getContentUpdates().collect((FlowCollector<Unit>)new FlowCollector(){

                            @Nullable
                            public final Object emit(@NotNull Unit it, @NotNull Continuation<? super Unit> $completion) {
                                this$0.updateIndices();
                                this$0.updateHighlighting();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation<?>)((Continuation)this));
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        EventListeners.addPropertyChangeListener(this.editorPane, this, "highlighter", arg_0 -> SearchModel._init_$lambda$1(this, arg_0));
        this.pattern = "";
        this.indices = new ArrayList();
        this.tagHandles = new ArrayList();
    }

    @NotNull
    public final SearchTextField getSearchField() {
        return this.searchField;
    }

    @NotNull
    public final JLabel getMatchLabel() {
        return this.matchLabel;
    }

    @Override
    public void dispose() {
        CoroutineScopeKt.cancel$default(this.cs, "SearchModel disposal", null, 2, null);
        this.pattern = "";
        this.indices.clear();
        this.currentSelection = -1;
        this.removeHighlights();
    }

    @NotNull
    public final List<AnAction> createNavigationActions() {
        Object[] objectArray = new DumbAwareAction[]{new DumbAwareAction(this){
            final /* synthetic */ SearchModel this$0;
            {
                this.this$0 = $receiver;
                ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"PreviousOccurence");
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(SearchModel.access$getHasPrev(this.this$0));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchModel.access$prev(this.this$0);
            }
        }, new DumbAwareAction(this){
            final /* synthetic */ SearchModel this$0;
            {
                this.this$0 = $receiver;
                ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"NextOccurence");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchModel.access$next(this.this$0);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(SearchModel.access$getHasNext(this.this$0));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        }};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void setPattern(String pattern) {
        if (Intrinsics.areEqual((Object)this.pattern, (Object)pattern)) {
            return;
        }
        this.pattern = pattern;
        this.updateIndices();
        this.updateHighlighting();
    }

    private final boolean getHasNext() {
        return this.currentSelection + 1 < this.indices.size();
    }

    private final boolean getHasPrev() {
        return this.currentSelection - 1 >= 0;
    }

    private final void next() {
        if (!this.getHasNext()) {
            boolean bl = false;
            String string2 = "Doesn't have next element";
            throw new IllegalStateException(string2.toString());
        }
        ++this.currentSelection;
        this.updateHighlighting();
        this.updateMatchLabel();
        this.scroll();
    }

    private final void prev() {
        if (!this.getHasPrev()) {
            boolean bl = false;
            String string2 = "Doesn't have prev element";
            throw new IllegalStateException(string2.toString());
        }
        --this.currentSelection;
        this.updateHighlighting();
        this.updateMatchLabel();
        this.scroll();
    }

    private final void near() {
        Object v0;
        Rectangle visibleRect = this.editorPane.getVisibleRect();
        Point visibleRestCenter = new Point((int)visibleRect.getCenterX(), (int)visibleRect.getCenterY());
        int currentOffset = this.editorPane.viewToModel2D(visibleRestCenter);
        Iterable $this$minByOrNull$iv = this.indices;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                int it = ((Number)minElem$iv).intValue();
                boolean bl = false;
                int minValue$iv = Math.abs(it - currentOffset);
                do {
                    Object e$iv = iterator$iv.next();
                    int it2 = ((Number)e$iv).intValue();
                    $i$a$-minByOrNull-SearchModel$near$nearestSelection$1 = false;
                    int v$iv = Math.abs(it2 - currentOffset);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Integer n = v0;
        if (n == null) {
            return;
        }
        int nearestSelection = n;
        this.currentSelection = this.indices.indexOf(nearestSelection);
        this.updateHighlighting();
        this.updateMatchLabel();
        this.scroll();
    }

    private final void scroll() {
        Integer n = this.indices.get(this.currentSelection);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"indices[currentSelection]");
        Rectangle viewRectangle = this.editorPane.modelToView(((Number)n).intValue());
        this.editorPane.scrollRectToVisible(viewRectangle);
    }

    private final void updateIndices() {
        this.indices.clear();
        this.currentSelection = 0;
        if (((CharSequence)this.pattern).length() > 0) {
            String text2 = this.editorPane.getDocument().getText(0, this.editorPane.getDocument().getLength());
            for (int index2 = 0; index2 < text2.length() && (index2 = StringUtil.indexOfIgnoreCase(text2, this.pattern, index2)) != -1; index2 += this.pattern.length()) {
                this.indices.add(index2);
            }
        }
        this.updateMatchLabel();
    }

    private final void updateMatchLabel() {
        this.matchLabel.setForeground(UIUtil.getLabelForeground());
        this.matchLabel.setFont(JBUI.Fonts.toolbarFont());
        int matches = this.indices.size();
        int cursorIndex = this.currentSelection + 1;
        if (((CharSequence)this.pattern).length() == 0) {
            this.searchField.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
            this.matchLabel.setText("");
        } else if (matches > 0) {
            this.searchField.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
            Object[] objectArray = new Object[]{cursorIndex, matches};
            this.matchLabel.setText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
        } else {
            this.searchField.getTextEditor().setBackground(LightColors.RED);
            this.matchLabel.setForeground(NamedColorUtil.getErrorForeground());
            Object[] objectArray = new Object[]{matches};
            this.matchLabel.setText(ApplicationBundle.message((String)"editorsearch.matches", (Object[])objectArray));
        }
    }

    private final void removeHighlights() {
        for (Function0<Unit> tagHandle : this.tagHandles) {
            tagHandle.invoke();
        }
        this.tagHandles.clear();
    }

    private final void updateHighlighting() {
        this.removeHighlights();
        Highlighter highlighter = this.editorPane.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Highlighter highlighter2 = highlighter;
        this.editorPane.invalidate();
        this.editorPane.repaint();
        for (Integer index2 : this.indices) {
            Intrinsics.checkNotNullExpressionValue((Object)index2, (String)"index");
            Object tag = highlighter2.addHighlight(index2, index2 + this.pattern.length(), new SearchHighlighterPainter(Intrinsics.areEqual((Object)this.indices.get(this.currentSelection), (Object)index2)));
            this.tagHandles.add(new Function0<Unit>(highlighter2, tag){
                final /* synthetic */ Highlighter $highlighter;
                final /* synthetic */ Object $tag;
                {
                    this.$highlighter = $highlighter;
                    this.$tag = $tag;
                    super(0);
                }

                public final void invoke() {
                    this.$highlighter.removeHighlight(this.$tag);
                }
            });
        }
    }

    private static final void _init_$lambda$1(SearchModel this$0, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateHighlighting();
    }

    public static final /* synthetic */ boolean access$getHasPrev(SearchModel $this) {
        return $this.getHasPrev();
    }

    public static final /* synthetic */ void access$prev(SearchModel $this) {
        $this.prev();
    }
}

