/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.ui;

import com.intellij.codeInsight.documentation.CornerAwareScrollPaneLayout;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.backend.documentation.LinkData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0000\u001a\u001f\u0010\f\u001a\u0004\u0018\u00010\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0000\u001a\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"#\u0010\u0002\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u00040\u0003\u00a2\u0006\u0002\b\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000*\u0018\b\u0000\u0010\u001a\"\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a8\u0006\u001d"}, d2={"DEFAULT_UI_RESPONSE_TIMEOUT", "", "FORCED_WIDTH", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "actionButton", "Ljavax/swing/JComponent;", "actions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "contextComponent", "linkChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "presentableText", "", "Lorg/jetbrains/annotations/Nls;", "links", "Lcom/intellij/platform/backend/documentation/LinkData;", "scrollPaneWithCorner", "parent", "Lcom/intellij/openapi/Disposable;", "scrollPane", "Ljavax/swing/JScrollPane;", "corner", "toolbarComponent", "UISnapshot", "Lkotlin/Function0;", "", "intellij.platform.lang.impl"})
public final class UiKt {
    public static final long DEFAULT_UI_RESPONSE_TIMEOUT = 300L;
    @JvmField
    @NotNull
    public static final Key<Integer> FORCED_WIDTH;

    @NotNull
    public static final JComponent toolbarComponent(@NotNull ActionGroup actions, @NotNull JComponent contextComponent) {
        JComponent jComponent;
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)contextComponent, (String)"contextComponent");
        ActionToolbar it = actionToolbar = ActionManager.getInstance().createActionToolbar("JavadocToolbar", actions, true);
        boolean bl = false;
        it.setSecondaryActionsIcon(AllIcons.Actions.More, true);
        it.setTargetComponent(contextComponent);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"getInstance().createActi\u2026ent(contextComponent)\n  }");
        ActionToolbar toolbar = actionToolbar2;
        JComponent jComponent2 = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"toolbar.component");
        JComponent it2 = jComponent = jComponent2;
        boolean bl2 = false;
        it2.setBorder(IdeBorderFactory.createBorder((Color)UIUtil.getTooltipSeparatorColor(), (int)8));
        return jComponent;
    }

    @NotNull
    public static final JComponent actionButton(@NotNull ActionGroup actions, @NotNull JComponent contextComponent) {
        Presentation presentation2;
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)contextComponent, (String)"contextComponent");
        Presentation it = presentation2 = new Presentation();
        boolean bl = false;
        it.setIcon(AllIcons.Actions.More);
        it.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
        Presentation presentation3 = presentation2;
        Dimension dimension = new Dimension(20, 20);
        ActionButton button2 = new ActionButton(actions, presentation3, contextComponent, dimension){
            final /* synthetic */ JComponent $contextComponent;
            {
                this.$contextComponent = $contextComponent;
                super((AnAction)$actions, $presentation, "unknown", $super_call_param$1);
            }

            @NotNull
            protected DataContext getDataContext() {
                DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this.$contextComponent);
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getInstance().getDataContext(contextComponent)");
                return dataContext2;
            }
        };
        button2.setNoIconsInPopup(true);
        return (JComponent)button2;
    }

    @NotNull
    public static final JComponent scrollPaneWithCorner(@NotNull Disposable parent2, @NotNull JScrollPane scrollPane, @NotNull JComponent corner) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        Intrinsics.checkNotNullParameter((Object)corner, (String)"corner");
        LayoutManager defaultLayout = scrollPane.getLayout();
        scrollPane.setLayout((LayoutManager)((Object)new CornerAwareScrollPaneLayout(corner)));
        Disposer.register(parent2, () -> UiKt.scrollPaneWithCorner$lambda$3(scrollPane, defaultLayout));
        JLayeredPane layeredPane2 = (JLayeredPane)new JBLayeredPane(scrollPane, corner){
            final /* synthetic */ JScrollPane $scrollPane;
            final /* synthetic */ JComponent $corner;
            {
                this.$scrollPane = $scrollPane;
                this.$corner = $corner;
            }

            public void doLayout() {
                Rectangle r = this.getBounds();
                Component[] componentArray = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"components");
                for (Component component2 : componentArray) {
                    if (component2 == this.$scrollPane) {
                        component2.setBounds(0, 0, r.width, r.height);
                        continue;
                    }
                    if (component2 == this.$corner) {
                        Dimension d = ((JComponent)component2).getPreferredSize();
                        component2.setBounds(r.width - d.width - 2, r.height - d.height - 2, d.width, d.height);
                        continue;
                    }
                    throw new IllegalStateException(("can't layout unexpected component: " + component2).toString());
                }
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension = this.$scrollPane.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"scrollPane.preferredSize");
                return dimension;
            }
        };
        Component component2 = scrollPane;
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
        layeredPane2.setLayer(component2, ((Number)n).intValue());
        layeredPane2.add(scrollPane);
        Component component3 = corner;
        Integer n2 = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"PALETTE_LAYER");
        layeredPane2.setLayer(component3, ((Number)n2).intValue());
        layeredPane2.add(corner);
        return layeredPane2;
    }

    @Nullable
    public static final HtmlChunk linkChunk(@NotNull String presentableText2, @NotNull LinkData links) {
        Intrinsics.checkNotNullParameter((Object)presentableText2, (String)"presentableText");
        Intrinsics.checkNotNullParameter((Object)links, (String)"links");
        String externalUrl = links.getExternalUrl();
        if (externalUrl != null) {
            HtmlChunk htmlChunk = DocumentationManager.getLink(presentableText2, externalUrl);
            if (htmlChunk == null) {
                htmlChunk = DocumentationManager.getGenericExternalDocumentationLink(presentableText2);
            }
            return htmlChunk;
        }
        List<String> linkUrls = links.getLinkUrls();
        if (!((Collection)linkUrls).isEmpty()) {
            HtmlChunk htmlChunk = DocumentationManager.getExternalLinks(presentableText2, linkUrls);
            if (htmlChunk == null) {
                htmlChunk = DocumentationManager.getGenericExternalDocumentationLink(presentableText2);
            }
            return htmlChunk;
        }
        return null;
    }

    private static final void scrollPaneWithCorner$lambda$3(JScrollPane $scrollPane, LayoutManager $defaultLayout) {
        Intrinsics.checkNotNullParameter((Object)$scrollPane, (String)"$scrollPane");
        $scrollPane.setLayout($defaultLayout);
    }

    static {
        Key key = Key.create("WidthBasedLayout.width");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create<Int>(\"WidthBasedLayout.width\")");
        FORCED_WIDTH = key;
    }
}

