/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.impl;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.model.psi.impl.UtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.DocumentationTargetProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"documentationTargets", "", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.platform.lang.impl"})
public final class TargetsKt {
    @NotNull
    public static final List<DocumentationTarget> documentationTargets(@NotNull PsiFile file2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        SmartList targets2 = new SmartList();
        for (DocumentationTargetProvider ext : DocumentationTargetProvider.EP_NAME.getExtensionList()) {
            targets2.addAll(ext.documentationTargets(file2, offset2));
        }
        if (!targets2.isEmpty()) {
            return targets2;
        }
        Editor editor2 = UtilKt.mockEditor(file2);
        if (editor2 == null) {
            return CollectionsKt.emptyList();
        }
        Editor editor3 = editor2;
        DocumentationManager documentationManager = DocumentationManager.getInstance(file2.getProject());
        Pair<PsiElement, PsiElement> pair = documentationManager.findTargetElementAndContext(editor3, offset2, file2);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<PsiElement, PsiElement> pair2 = pair;
        PsiElement targetElement = ExtensionsKt.component1(pair2);
        PsiElement sourceElement = ExtensionsKt.component2(pair2);
        Intrinsics.checkNotNullExpressionValue((Object)targetElement, (String)"targetElement");
        return CollectionsKt.listOf((Object)com.intellij.lang.documentation.psi.UtilKt.psiDocumentationTarget(targetElement, sourceElement));
    }
}

