/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.psi;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.psi.PsiElementDocumentationTarget;
import com.intellij.lang.documentation.psi.PsiExternalDocumentationHandlerTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.backend.documentation.DocumentationLinkHandler;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.LinkResolveResult;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/documentation/psi/PsiDocumentationLinkHandler;", "Lcom/intellij/platform/backend/documentation/DocumentationLinkHandler;", "()V", "resolveLink", "Lcom/intellij/platform/backend/documentation/LinkResolveResult;", "target", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "url", "", "intellij.platform.lang.impl"})
public final class PsiDocumentationLinkHandler
implements DocumentationLinkHandler {
    @Override
    @Nullable
    public LinkResolveResult resolveLink(@NotNull DocumentationTarget target2, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!(target2 instanceof PsiElementDocumentationTarget)) {
            return null;
        }
        PsiElement element = ((PsiElementDocumentationTarget)target2).getTargetElement();
        if (StringsKt.startsWith$default((String)url, (String)"psi_element://", (boolean)false, (int)2, null)) {
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            Project project3 = project2;
            Pair<PsiElement, String> pair = DocumentationManager.targetAndRef(project3, url, element);
            if (pair == null) {
                return null;
            }
            Pair<PsiElement, String> pair2 = pair;
            PsiElement resolved = ExtensionsKt.component1(pair2);
            String anchor = ExtensionsKt.component2(pair2);
            Intrinsics.checkNotNullExpressionValue((Object)resolved, (String)"resolved");
            return LinkResolveResult.Companion.resolvedTarget(new PsiElementDocumentationTarget(project3, resolved, null, anchor));
        }
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element);
        Intrinsics.checkNotNullExpressionValue((Object)documentationProvider, (String)"getProviderFromElement(element)");
        DocumentationProvider provider2 = documentationProvider;
        if (provider2 instanceof CompositeDocumentationProvider) {
            for (DocumentationProvider p : ((CompositeDocumentationProvider)provider2).getAllProviders()) {
                if (!(p instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)p)).canFetchDocumentationLink(url)) continue;
                return LinkResolveResult.Companion.resolvedTarget(new PsiExternalDocumentationHandlerTarget((ExternalDocumentationHandler)((Object)p), url, element));
            }
        }
        return null;
    }
}

