/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.psi;

import com.intellij.lang.documentation.psi.PsiElementDocumentationTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.PsiDocumentationTargetProvider;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isNavigatableQuickDoc", "", "source", "Lcom/intellij/psi/PsiElement;", "target", "psiDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "element", "originalElement", "intellij.platform.lang.impl"})
public final class UtilKt {
    @JvmField
    @NotNull
    public static final Logger LOG;

    @NotNull
    public static final DocumentationTarget psiDocumentationTarget(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (PsiDocumentationTargetProvider ext : PsiDocumentationTargetProvider.EP_NAME.getExtensionList()) {
            DocumentationTarget documentationTarget = ext.documentationTarget(element, originalElement);
            if (documentationTarget == null) continue;
            return documentationTarget;
        }
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        return new PsiElementDocumentationTarget(project2, element, originalElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNavigatableQuickDoc(@Nullable PsiElement source, @NotNull PsiElement target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        if (target2 == source) return false;
        PsiElement psiElement = source;
        if (target2 == (psiElement != null ? psiElement.getParent() : null)) return false;
        return true;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.lang.documentation.psi");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#com.intell\u2026.lang.documentation.psi\")");
        LOG = logger;
    }
}

