/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.lang.LangBundle;
import com.intellij.lang.javascript.boilerplate.AbstractGithubTagDownloadedProjectGenerator;
import com.intellij.lang.javascript.boilerplate.GithubTagListProvider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ReloadableComboBoxPanel;
import com.intellij.util.ui.ReloadablePanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubProjectGeneratorPeer
implements WebProjectGenerator.GeneratorPeer<GithubTagInfo> {
    private final List<WebProjectGenerator.SettingsStateListener> myListeners;
    private final GithubTagInfo myDefaultBranchTag;
    private final GithubTagListProvider myTagListProvider;
    private JComponent myComponent;
    private JPanel myVersionPanel;
    private ReloadablePanel<GithubTagInfo> myReloadableComboBoxPanel;

    public static String getGithubZipballUrl(String ghUserName, String ghRepoName, String branch) {
        return String.format("https://github.com/%s/%s/zipball/%s", ghUserName, ghRepoName, branch);
    }

    private void createUIComponents() {
        this.myReloadableComboBoxPanel = new ReloadableComboBoxPanel<GithubTagInfo>(){

            protected void doUpdateValues(@NotNull Set<GithubTagInfo> tags) {
                if (tags == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.shouldUpdate(tags)) {
                    return;
                }
                List<GithubTagInfo> sortedTags = GithubProjectGeneratorPeer.createSortedTagList(tags);
                GithubTagInfo selectedItem = (GithubTagInfo)this.getSelectedValue();
                if (selectedItem == null && sortedTags.size() > 0) {
                    selectedItem = sortedTags.get(0);
                }
                this.myComboBox.removeAllItems();
                if (GithubProjectGeneratorPeer.this.myDefaultBranchTag != null) {
                    this.myComboBox.addItem(GithubProjectGeneratorPeer.this.myDefaultBranchTag);
                }
                for (GithubTagInfo tag : sortedTags) {
                    this.myComboBox.addItem(tag);
                }
                if (selectedItem != null) {
                    for (int i2 = 0; i2 < this.myComboBox.getItemCount(); ++i2) {
                        GithubTagInfo item = GithubTagInfo.tryCast(this.myComboBox.getItemAt(i2));
                        if (item == null || !item.getName().equals(selectedItem.getName())) continue;
                        this.myComboBox.setSelectedIndex(i2);
                        break;
                    }
                }
                this.myComboBox.updateUI();
                GithubProjectGeneratorPeer.this.fireStateChanged();
            }

            private boolean shouldUpdate(Set<GithubTagInfo> newTags) {
                if (this.myComboBox.getItemCount() == 0) {
                    return true;
                }
                int count2 = this.myComboBox.getItemCount();
                HashSet<GithubTagInfo> oldTags = new HashSet<GithubTagInfo>();
                for (int i2 = 1; i2 < count2; ++i2) {
                    GithubTagInfo item = ObjectUtils.tryCast(this.myComboBox.getItemAt(i2), GithubTagInfo.class);
                    if (item == null) continue;
                    oldTags.add(item);
                }
                return !oldTags.equals(newTags);
            }

            @NotNull
            protected JComboBox<GithubTagInfo> createValuesComboBox() {
                JComboBox box2 = super.createValuesComboBox();
                box2.setRenderer(SimpleListCellRenderer.create((label2, tag, index2) -> {
                    String text2 = tag == null ? (this.isBackgroundJobRunning() ? CommonBundle.getLoadingTreeNodeText() : LangBundle.message("label.unavailable", new Object[0])) : tag.getName();
                    label2.setText(text2);
                }));
                JComboBox jComboBox = box2;
                if (jComboBox == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jComboBox;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tags";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValuesComboBox";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doUpdateValues";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        };
        this.myVersionPanel = this.myReloadableComboBoxPanel.getMainPanel();
    }

    public GithubProjectGeneratorPeer(@NotNull AbstractGithubTagDownloadedProjectGenerator generator) {
        if (generator == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myListeners = new ArrayList<WebProjectGenerator.SettingsStateListener>();
        String ghUserName = generator.getGithubUserName();
        String ghRepoName = generator.getGithubRepositoryName();
        String defaultBranchName = generator.getDefaultBranchName();
        this.myDefaultBranchTag = defaultBranchName != null ? new GithubTagInfo(defaultBranchName, GithubProjectGeneratorPeer.getGithubZipballUrl(ghUserName, ghRepoName, defaultBranchName)) : null;
        this.myTagListProvider = new GithubTagListProvider(ghUserName, ghRepoName);
        this.myReloadableComboBoxPanel.setDataProvider((ReloadablePanel.DataProvider)new ReloadablePanel.DataProvider<GithubTagInfo>(){

            public Set<GithubTagInfo> getCachedValues() {
                return GithubProjectGeneratorPeer.this.myTagListProvider.getCachedTags();
            }

            public void updateValuesAsynchronously() {
                GithubProjectGeneratorPeer.this.myTagListProvider.updateTagListAsynchronously(GithubProjectGeneratorPeer.this);
            }
        });
        this.myReloadableComboBoxPanel.reloadValuesInBackground();
    }

    void onTagsUpdated(@NotNull Set<GithubTagInfo> tags) {
        if (tags == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(1);
        }
        this.myReloadableComboBoxPanel.onUpdateValues(tags);
    }

    void onTagsUpdateError(@NotNull @NlsContexts.DialogMessage String errorMessage) {
        if (errorMessage == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(2);
        }
        this.myReloadableComboBoxPanel.onValuesUpdateError(errorMessage);
    }

    @NotNull
    private static List<GithubTagInfo> createSortedTagList(@NotNull Collection<? extends GithubTagInfo> tags) {
        if (tags == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(3);
        }
        ArrayList<GithubTagInfo> sortedTags = new ArrayList<GithubTagInfo>(tags);
        sortedTags.sort((tag1, tag2) -> {
            GithubTagInfo.Version v1 = tag1.getVersion();
            GithubTagInfo.Version v2 = tag2.getVersion();
            return v2.compareTo(v1);
        });
        for (GithubTagInfo tag : sortedTags) {
            tag.setRecentTag(false);
        }
        if (!sortedTags.isEmpty()) {
            ((GithubTagInfo)sortedTags.get(0)).setRecentTag(true);
        }
        ArrayList<GithubTagInfo> arrayList = sortedTags;
        if (arrayList == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(6);
        }
        settingsStep.addSettingsField(BundleBase.replaceMnemonicAmpersand(IdeBundle.message((String)"github.project.generator.version", (Object[])new Object[0])), (JComponent)this.myVersionPanel);
        settingsStep.addSettingsComponent((JComponent)this.myReloadableComboBoxPanel.getErrorComponent());
    }

    @NotNull
    public GithubTagInfo getSettings() {
        GithubTagInfo tag = (GithubTagInfo)this.myReloadableComboBoxPanel.getSelectedValue();
        if (tag == null) {
            throw new RuntimeException("[internal error] No versions available.");
        }
        GithubTagInfo githubTagInfo = tag;
        if (githubTagInfo == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(7);
        }
        return githubTagInfo;
    }

    @Nullable
    public ValidationInfo validate() {
        GithubTagInfo tag = (GithubTagInfo)this.myReloadableComboBoxPanel.getSelectedValue();
        if (tag != null) {
            return null;
        }
        String errorMessage = StringUtil.notNullize(this.myReloadableComboBoxPanel.getErrorComponent().getText());
        if (errorMessage.isEmpty()) {
            errorMessage = IdeBundle.message((String)"github.project.generator.versions.not.loaded.error", (Object[])new Object[0]);
        }
        return new ValidationInfo(errorMessage);
    }

    public boolean isBackgroundJobRunning() {
        return this.myReloadableComboBoxPanel.isBackgroundJobRunning();
    }

    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener2) {
        if (listener2 == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(8);
        }
        this.myListeners.add(listener2);
    }

    private void fireStateChanged() {
        GithubTagInfo tag = (GithubTagInfo)this.myReloadableComboBoxPanel.getSelectedValue();
        for (WebProjectGenerator.SettingsStateListener listener2 : this.myListeners) {
            listener2.stateChanged(tag != null);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        this.createUIComponents();
        JPanel jPanel = new JPanel();
        this.myComponent = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = this.myVersionPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/LangBundle", GithubProjectGeneratorPeer.class).getString("label.github.project.version"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSortedTagList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onTagsUpdated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTagsUpdateError";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSortedTagList";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildUI";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 7 -> new IllegalStateException(string2);
        };
    }
}

