/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.LangBundle;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubTagListProvider {
    private static final Logger LOG = Logger.getInstance(GithubTagListProvider.class);
    private final String myUserName;
    private final String myRepositoryName;

    public GithubTagListProvider(@NotNull String userName, @NotNull String repositoryName) {
        if (userName == null) {
            GithubTagListProvider.$$$reportNull$$$0(0);
        }
        if (repositoryName == null) {
            GithubTagListProvider.$$$reportNull$$$0(1);
        }
        this.myUserName = userName;
        this.myRepositoryName = repositoryName;
    }

    @Nullable
    public ImmutableSet<GithubTagInfo> getCachedTags() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        File cacheFile = this.getTagsCacheFile();
        if (cacheFile.isFile()) {
            try {
                ImmutableSet<GithubTagInfo> tags = this.readTagsFromFile(cacheFile);
                LOG.info(this.getGeneratorName() + "tag info list has been successfully read from cache file " + cacheFile.getAbsolutePath());
                return tags;
            }
            catch (GeneratorException e) {
                LOG.warn("Can't read cache file " + cacheFile.getAbsolutePath(), e);
            }
        }
        return null;
    }

    public void updateTagListAsynchronously(@NotNull GithubProjectGeneratorPeer peer) {
        if (peer == null) {
            GithubTagListProvider.$$$reportNull$$$0(2);
        }
        Runnable action2 = this.createUpdateTagListAction(peer);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            action2.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(action2);
        }
    }

    private Runnable createUpdateTagListAction(@NotNull GithubProjectGeneratorPeer peer) {
        if (peer == null) {
            GithubTagListProvider.$$$reportNull$$$0(3);
        }
        return () -> {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                peer.onTagsUpdated(Collections.emptySet());
                return;
            }
            String[] urls = this.formatTagListDownloadUrls();
            @NlsContexts.DialogMessage String firstErrorMessage = null;
            for (String url : urls) {
                String errorMessage;
                try {
                    ImmutableSet<GithubTagInfo> tags = this.fetchGithubTagsByUrl(url);
                    LOG.info(this.getGeneratorName() + "Cache has been successfully updated");
                    UIUtil.invokeLaterIfNeeded(() -> peer.onTagsUpdated((Set<GithubTagInfo>)tags));
                    return;
                }
                catch (IOException e) {
                    errorMessage = LangBundle.message("dialog.message.can.not.fetch.tags.from", url);
                    LOG.warn(this.getGeneratorName() + errorMessage, e);
                }
                catch (GeneratorException e) {
                    errorMessage = LangBundle.message("dialog.message.malformed.json.received.from", url);
                    LOG.warn(this.getGeneratorName() + errorMessage, e);
                }
                if (firstErrorMessage != null) continue;
                firstErrorMessage = errorMessage;
            }
            if (firstErrorMessage != null) {
                peer.onTagsUpdateError(firstErrorMessage);
            }
        };
    }

    private ImmutableSet<GithubTagInfo> fetchGithubTagsByUrl(@NotNull String url) throws IOException, GeneratorException {
        if (url == null) {
            GithubTagListProvider.$$$reportNull$$$0(4);
        }
        LOG.info(this.getGeneratorName() + "starting cache update from " + url + " ...");
        File cacheFile = this.getTagsCacheFile();
        GithubDownloadUtil.downloadAtomically(null, url, cacheFile, this.myUserName, this.myRepositoryName);
        return this.readTagsFromFile(cacheFile);
    }

    private String getGeneratorName() {
        return "[" + this.myUserName + "/" + this.myRepositoryName + "] ";
    }

    @NotNull
    private ImmutableSet<GithubTagInfo> readTagsFromFile(@NotNull File file2) throws GeneratorException {
        String content2;
        if (file2 == null) {
            GithubTagListProvider.$$$reportNull$$$0(5);
        }
        try {
            content2 = Files.toString((File)file2, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new GeneratorException(LangBundle.message("dialog.message.can.read", file2.getAbsolutePath()), e);
        }
        try {
            return GithubTagListProvider.parseContent(content2);
        }
        catch (GeneratorException e) {
            String message = String.format("%s parsing version list failed: %s\n%s", this.getGeneratorName(), e.getMessage(), content2);
            LOG.info(message, e);
            throw e;
        }
    }

    @NotNull
    private static ImmutableSet<GithubTagInfo> parseContent(@NotNull String tagFileContent) throws GeneratorException {
        JsonElement jsonElement;
        if (tagFileContent == null) {
            GithubTagListProvider.$$$reportNull$$$0(6);
        }
        if (tagFileContent.trim().isEmpty()) {
            throw new GeneratorException(LangBundle.message("dialog.message.can.parse.fetched.version.list.got.empty.response", new Object[0]));
        }
        try {
            JsonParser jsonParser = new JsonParser();
            jsonElement = jsonParser.parse(tagFileContent);
        }
        catch (Exception e) {
            throw new GeneratorException(LangBundle.message("dialog.message.can.parse.fetched.version.list.malformed.json.was.received", new Object[0]));
        }
        return GithubTagListProvider.toGithubTagList(jsonElement);
    }

    @NotNull
    private static ImmutableSet<GithubTagInfo> toGithubTagList(@NotNull JsonElement jsonElement) throws GeneratorException {
        if (jsonElement == null) {
            GithubTagListProvider.$$$reportNull$$$0(7);
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            ImmutableSet.Builder tags = ImmutableSet.builder();
            for (JsonElement element : array) {
                if (element instanceof JsonObject) {
                    JsonObject obj = (JsonObject)element;
                    JsonElement nameElement = obj.get("name");
                    String name = null;
                    if (nameElement != null) {
                        name = nameElement.getAsString();
                    }
                    String zipball = null;
                    JsonElement zipballElement = obj.get("zipball_url");
                    if (zipballElement != null) {
                        zipball = zipballElement.getAsString();
                    }
                    if (name == null || zipball == null) continue;
                    tags.add((Object)new GithubTagInfo(name, zipball));
                    continue;
                }
                throw new GeneratorException(LangBundle.message("dialog.message.unexpected.child.element", element.getClass().getName()));
            }
            ImmutableSet immutableSet = tags.build();
            if (immutableSet == null) {
                GithubTagListProvider.$$$reportNull$$$0(8);
            }
            return immutableSet;
        }
        throw new GeneratorException(LangBundle.message("dialog.message.jsonelement.expected.be.instance", JsonArray.class.getName()));
    }

    @NotNull
    private File getTagsCacheFile() {
        File dir = GithubDownloadUtil.getCacheDir(this.myUserName, this.myRepositoryName);
        return new File(dir, "tags.json");
    }

    private String @NotNull [] formatTagListDownloadUrls() {
        String[] stringArray = new String[]{"https://api.github.com/repos/" + this.myUserName + "/" + this.myRepositoryName + "/tags", "https://download.jetbrains.com/idea/project_templates/github-tags/" + this.myUserName + "-" + this.myRepositoryName + "-tags.json"};
        if (stringArray == null) {
            GithubTagListProvider.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagFileContent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/GithubTagListProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/GithubTagListProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toGithubTagList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTagListDownloadUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateTagListAsynchronously";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateTagListAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchGithubTagsByUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readTagsFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toGithubTagList";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9 -> new IllegalStateException(string2);
        };
    }
}

