/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parameterInfo;

import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUtilsBase;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterInfoUtils {
    public static final String DEFAULT_PARAMETER_CLOSE_CHARS = ",){}";

    @Nullable
    public static <T extends PsiElement> T findParentOfType(PsiFile file2, int offset2, Class<T> parentClass) {
        return ParameterInfoUtilsBase.findParentOfType(file2, offset2, parentClass);
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T findParentOfTypeWithStopElements(PsiFile file2, int offset2, Class<T> parentClass, Class<? extends PsiElement> ... stopAt) {
        if (stopAt == null) {
            ParameterInfoUtils.$$$reportNull$$$0(0);
        }
        return ParameterInfoUtilsBase.findParentOfTypeWithStopElements(file2, offset2, parentClass, stopAt);
    }

    public static int getCurrentParameterIndex(ASTNode argList, int offset2, IElementType delimiterType) {
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.astTraverser(argList).expandAndSkip(Conditions.is(argList));
        return ParameterInfoUtils.getCurrentParameterIndex(s, offset2, delimiterType);
    }

    public static <V> int getCurrentParameterIndex(SyntaxTraverser<V> s, int offset2, IElementType delimiterType) {
        Object root = s.getRoot();
        int curOffset = s.api.rangeOf(root).getStartOffset();
        if (offset2 < curOffset) {
            return -1;
        }
        int index2 = 0;
        for (Object child : s) {
            if (offset2 < (curOffset += s.api.rangeOf(child).getLength())) break;
            IElementType type = s.api.typeOf(child);
            if (type != delimiterType) continue;
            ++index2;
        }
        return index2;
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset2, int lbraceOffset, @NotNull ParameterInfoHandlerWithTabActionSupport findArgumentListHelper) {
        if (findArgumentListHelper == null) {
            ParameterInfoUtils.$$$reportNull$$$0(1);
        }
        return ParameterInfoUtils.findArgumentList(file2, offset2, lbraceOffset, findArgumentListHelper, true);
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset2, int lbraceOffset, @NotNull ParameterInfoHandlerWithTabActionSupport findArgumentListHelper, boolean allowOuter) {
        PsiElement element;
        int offset1;
        if (findArgumentListHelper == null) {
            ParameterInfoUtils.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            return null;
        }
        CharSequence chars = file2.getViewProvider().getContents();
        if (offset2 >= chars.length()) {
            offset2 = chars.length() - 1;
        }
        if ((offset1 = CharArrayUtil.shiftBackward(chars, offset2, " \t\n\r")) < 0) {
            return null;
        }
        boolean acceptRparenth = true;
        boolean acceptLparenth = false;
        if (offset1 != offset2) {
            offset2 = offset1;
            acceptRparenth = false;
            acceptLparenth = true;
        }
        if ((element = file2.findElementAt(offset2)) == null) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        while (true) {
            TextRange range;
            if (findArgumentListHelper.getArgumentListClass().isInstance(parent2) && (range = parent2.getTextRange()) != null) {
                if (!acceptRparenth && offset2 == range.getEndOffset() - 1) {
                    PsiElement[] children2 = parent2.getChildren();
                    if (children2.length == 0) {
                        return null;
                    }
                    PsiElement last2 = children2[children2.length - 1];
                    if (last2.getNode().getElementType() == findArgumentListHelper.getActualParametersRBraceType()) {
                        parent2 = parent2.getParent();
                        continue;
                    }
                }
                if (!acceptLparenth && offset2 == range.getStartOffset()) {
                    parent2 = parent2.getParent();
                    continue;
                }
                if (lbraceOffset < 0 || range.getStartOffset() == lbraceOffset) break;
                if (!allowOuter) {
                    return null;
                }
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof PsiFile || parent2 == null) {
                return null;
            }
            Set<Class<?>> set2 = findArgumentListHelper.getArgListStopSearchClasses();
            for (Class<?> aClass : set2) {
                if (!aClass.isInstance(parent2)) continue;
                return null;
            }
            parent2 = parent2.getParent();
        }
        PsiElement listParent = parent2.getParent();
        for (Class<?> c2 : findArgumentListHelper.getArgumentListAllowedParentClasses()) {
            if (!c2.isInstance(listParent)) continue;
            return (E)parent2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findArgumentListHelper";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/parameterInfo/ParameterInfoUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentOfTypeWithStopElements";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findArgumentList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

