/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.largeFilesEditor.editor.LargeFileEditorImpl;
import com.intellij.largeFilesEditor.editor.LargeFileEditorState;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.DefaultPlatformFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LargeFileEditorProvider
implements DefaultPlatformFileEditorProvider,
DumbAware {
    public static final String PROVIDER_ID = "LargeFileEditorProvider";
    @NonNls
    private static final String CARET_PAGE_NUMBER_ATTR = "caret-page-number";
    @NonNls
    private static final String CARET_PAGE_SYMBOL_OFFSET_ATTR = "caret-page-symbol-offset";

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(1);
        }
        return TextEditorProvider.isTextFile((VirtualFile)file2) && SingleRootFileViewProvider.isTooLargeForContentLoading(file2) && Experiments.getInstance().isFeatureEnabled("new.large.text.file.viewer") && !file2.getFileType().isBinary() && file2.isInLocalFileSystem();
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(3);
        }
        return new LargeFileEditorImpl(project2, file2);
    }

    @NotNull
    public String getEditorTypeId() {
        return PROVIDER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.NONE;
        if (fileEditorPolicy == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(4);
        }
        return fileEditorPolicy;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project2, @NotNull Element targetElement) {
        if (state == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(6);
        }
        if (targetElement == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(7);
        }
        if (state instanceof LargeFileEditorState) {
            targetElement.setAttribute(CARET_PAGE_NUMBER_ATTR, Long.toString(((LargeFileEditorState)state).caretPageNumber));
            targetElement.setAttribute(CARET_PAGE_SYMBOL_OFFSET_ATTR, Integer.toString(((LargeFileEditorState)state).caretSymbolOffsetInPage));
        }
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project2, @NotNull VirtualFile file2) {
        if (sourceElement == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(10);
        }
        LargeFileEditorState state = new LargeFileEditorState();
        if (JDOMUtil.isEmpty(sourceElement)) {
            LargeFileEditorState largeFileEditorState = state;
            if (largeFileEditorState == null) {
                LargeFileEditorProvider.$$$reportNull$$$0(11);
            }
            return largeFileEditorState;
        }
        state.caretPageNumber = StringUtilRt.parseLong(sourceElement.getAttributeValue(CARET_PAGE_NUMBER_ATTR), 0L);
        state.caretSymbolOffsetInPage = StringUtilRt.parseInt(sourceElement.getAttributeValue(CARET_PAGE_SYMBOL_OFFSET_ATTR), 0);
        LargeFileEditorState largeFileEditorState = state;
        if (largeFileEditorState == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(12);
        }
        return largeFileEditorState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/largeFilesEditor/editor/LargeFileEditorProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/largeFilesEditor/editor/LargeFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 11, 12 -> new IllegalStateException(string2);
        };
    }
}

