/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LargeFileNotificationProvider
implements EditorNotificationProvider {
    private static final Key<String> HIDDEN_KEY = Key.create("large.file.editor.notification.hidden");
    private static final String DISABLE_KEY = "large.file.editor.notification.disabled";

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(1);
        }
        return fileEditor -> {
            if (!(fileEditor instanceof LargeFileEditor)) {
                return null;
            }
            Editor editor2 = ((LargeFileEditor)fileEditor).getEditor();
            if (editor2.getUserData(HIDDEN_KEY) != null || PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            panel2.createActionLabel(EditorBundle.message((String)"notification.hide.message", (Object[])new Object[0]), () -> {
                editor2.putUserData(HIDDEN_KEY, (Object)"true");
                LargeFileNotificationProvider.update(file2, project2);
            });
            panel2.createActionLabel(EditorBundle.message((String)"notification.dont.show.again.message", (Object[])new Object[0]), () -> {
                PropertiesComponent.getInstance().setValue(DISABLE_KEY, "true");
                LargeFileNotificationProvider.update(file2, project2);
            });
            return panel2.text(EditorBundle.message((String)"large.file.editor.notification.text.the.file.is.too.large.so.showing.in.read.only.mode", (Object[])new Object[]{StringUtil.formatFileSize(file2.getLength())}));
        };
    }

    private static void update(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(3);
        }
        EditorNotifications.getInstance((Project)project2).updateNotifications(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/largeFilesEditor/editor/LargeFileNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

