/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.actions;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.largeFilesEditor.search.LfeSearchManager;
import com.intellij.largeFilesEditor.search.searchTask.CloseSearchTask;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeFilePrevNextOccurrenceAction
extends DumbAwareAction
implements ContextAwareShortcutProvider {
    private final LfeSearchManager mySearchManager;
    private final boolean myDirectionForward;

    public LargeFilePrevNextOccurrenceAction(LfeSearchManager searchManager, boolean directionForward) {
        this.mySearchManager = searchManager;
        this.myDirectionForward = directionForward;
        this.copyFrom(ActionManager.getInstance().getAction(directionForward ? "NextOccurence" : "PreviousOccurence"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LargeFilePrevNextOccurrenceAction.$$$reportNull$$$0(0);
        }
        if (this.isEnabled()) {
            this.mySearchManager.gotoNextOccurrence(this.myDirectionForward);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LargeFilePrevNextOccurrenceAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isEnabled());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            LargeFilePrevNextOccurrenceAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private boolean isEnabled() {
        CloseSearchTask task2 = this.mySearchManager.getLastExecutedCloseSearchTask();
        return task2 == null || task2.isFinished();
    }

    @Override
    @Nullable
    public ShortcutSet getShortcut(@NotNull DataContext context2) {
        boolean isSingleLine;
        if (context2 == null) {
            LargeFilePrevNextOccurrenceAction.$$$reportNull$$$0(3);
        }
        ArrayList<Shortcut> list2 = new ArrayList<Shortcut>();
        boolean bl = isSingleLine = !this.isMultiLine();
        if (this.myDirectionForward) {
            list2.addAll(Utils.shortcutsOf("FindNext"));
            if (isSingleLine) {
                list2.addAll(Utils.shortcutsOf("EditorDown"));
                Collections.addAll(list2, CommonShortcuts.ENTER.getShortcuts());
            }
        } else {
            list2.addAll(Utils.shortcutsOf("FindPrevious"));
            if (isSingleLine) {
                list2.addAll(Utils.shortcutsOf("EditorUp"));
                list2.add((Shortcut)new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null));
            }
        }
        return Utils.shortcutSetOf(list2);
    }

    private boolean isMultiLine() {
        SearchReplaceComponent searchReplaceComponent = this.mySearchManager.getSearchReplaceComponent();
        return searchReplaceComponent != null && searchReplaceComponent.isMultiline();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/largeFilesEditor/search/actions/LargeFilePrevNextOccurrenceAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/largeFilesEditor/search/actions/LargeFilePrevNextOccurrenceAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getShortcut";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

