/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.model.psi.impl.PsiOrigin;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/model/psi/impl/EvaluatorReference;", "Lcom/intellij/model/psi/PsiSymbolReference;", "origin", "Lcom/intellij/model/psi/impl/PsiOrigin;", "targetElements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/model/psi/impl/PsiOrigin;Ljava/util/Collection;)V", "getOrigin", "()Lcom/intellij/model/psi/impl/PsiOrigin;", "getTargetElements", "()Ljava/util/Collection;", "getAbsoluteRange", "Lcom/intellij/openapi/util/TextRange;", "getElement", "getRangeInElement", "resolveReference", "Lcom/intellij/model/Symbol;", "toString", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nEvaluatorReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluatorReference.kt\ncom/intellij/model/psi/impl/EvaluatorReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1549#2:32\n1620#2,3:33\n*S KotlinDebug\n*F\n+ 1 EvaluatorReference.kt\ncom/intellij/model/psi/impl/EvaluatorReference\n*L\n26#1:32\n26#1:33,3\n*E\n"})
public final class EvaluatorReference
implements PsiSymbolReference {
    @NotNull
    private final PsiOrigin origin;
    @NotNull
    private final Collection<PsiElement> targetElements;

    public EvaluatorReference(@NotNull PsiOrigin origin, @NotNull Collection<? extends PsiElement> targetElements) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(targetElements, (String)"targetElements");
        this.origin = origin;
        this.targetElements = targetElements;
    }

    @NotNull
    public final PsiOrigin getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Collection<PsiElement> getTargetElements() {
        return this.targetElements;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        return this.origin.getElementAtPointer();
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.getAbsoluteRange().shiftLeft(this.getElement().getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"absoluteRange.shiftLeft(\u2026nt.textRange.startOffset)");
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getAbsoluteRange() {
        List<TextRange> absoluteRanges = this.origin.getAbsoluteRanges();
        TextRange textRange = (TextRange)CollectionsKt.singleOrNull(absoluteRanges);
        if (textRange == null) {
            TextRange textRange2 = TextRange.create(((TextRange)CollectionsKt.first(absoluteRanges)).getStartOffset(), ((TextRange)CollectionsKt.last(absoluteRanges)).getEndOffset());
            textRange = textRange2;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"create(absoluteRanges.fi\u2026eRanges.last().endOffset)");
        }
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Symbol> resolveReference() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.targetElements;
        PsiSymbolService psiSymbolService = PsiSymbolService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)psiSymbolService, (String)"getInstance()");
        PsiSymbolService psiSymbolService2 = psiSymbolService;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(psiSymbolService2.asSymbol((PsiElement)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return "EvaluatorReference(origin=" + this.origin + ", targetElements=" + this.targetElements + ")";
    }
}

