/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.model.psi.impl.PsiElement2Declaration;
import com.intellij.model.search.PsiSymbolDeclarationSearchParameters;
import com.intellij.model.search.PsiSymbolDeclarationSearcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/model/psi/impl/PsiElementDeclarationSearcher;", "Lcom/intellij/model/search/PsiSymbolDeclarationSearcher;", "()V", "collectImmediateResults", "", "Lcom/intellij/model/psi/PsiSymbolDeclaration;", "parameters", "Lcom/intellij/model/search/PsiSymbolDeclarationSearchParameters;", "fromPomTargetElement", "psi", "Lcom/intellij/pom/PomTargetPsiElement;", "getDeclaration", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "inGlobalScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "inLocalScope", "Lcom/intellij/psi/search/LocalSearchScope;", "intellij.platform.lang.impl"})
public final class PsiElementDeclarationSearcher
implements PsiSymbolDeclarationSearcher {
    @NotNull
    public Collection<PsiSymbolDeclaration> collectImmediateResults(@NotNull PsiSymbolDeclarationSearchParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        PsiElement psiElement = PsiSymbolService.getInstance().extractElementFromSymbol(parameters2.getSymbol());
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement psi = psiElement;
        SearchScope searchScope2 = parameters2.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"parameters.searchScope");
        PsiSymbolDeclaration psiSymbolDeclaration = this.getDeclaration(psi, searchScope2);
        if (psiSymbolDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        PsiSymbolDeclaration declaration = psiSymbolDeclaration;
        return CollectionsKt.listOf((Object)declaration);
    }

    private final PsiSymbolDeclaration getDeclaration(PsiElement psi, SearchScope searchScope2) {
        if (searchScope2 instanceof LocalSearchScope) {
            return this.inLocalScope(psi, (LocalSearchScope)searchScope2);
        }
        Intrinsics.checkNotNull((Object)searchScope2, (String)"null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
        return this.inGlobalScope(psi, (GlobalSearchScope)searchScope2);
    }

    private final PsiSymbolDeclaration inLocalScope(PsiElement psi, LocalSearchScope searchScope2) {
        PsiElement[] psiElementArray = searchScope2.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"searchScope.scope");
        for (PsiElement scopeElement : psiElementArray) {
            PsiFile scopeFile;
            if (scopeElement.getContainingFile() == null) continue;
            Pair<PsiElement, TextRange> pair = HighlightUsagesHandler.getNameIdentifierRangeInCurrentRoot(scopeFile, psi);
            if (pair == null) continue;
            Pair<PsiElement, TextRange> declarationRange = pair;
            return new PsiElement2Declaration(psi, scopeFile, declarationRange.getSecond());
        }
        return null;
    }

    private final PsiSymbolDeclaration inGlobalScope(PsiElement psi, GlobalSearchScope searchScope2) {
        PsiFile psiFile = psi.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile containingFile = psiFile;
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (!searchScope2.contains(virtualFile3)) {
            return null;
        }
        PsiElement psiElement = psi;
        return psiElement instanceof PsiFile ? null : (psiElement instanceof PomTargetPsiElement ? this.fromPomTargetElement((PomTargetPsiElement)psi) : PsiElement2Declaration.createFromTargetPsiElement(psi));
    }

    private final PsiSymbolDeclaration fromPomTargetElement(PomTargetPsiElement psi) {
        PomTarget pomTarget = psi.getTarget();
        PsiTarget psiTarget = pomTarget instanceof PsiTarget ? (PsiTarget)pomTarget : null;
        if (psiTarget == null) {
            return null;
        }
        PsiTarget target2 = psiTarget;
        PsiElement psiElement = target2.getNavigationElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"target.navigationElement");
        PsiElement navigationElement = psiElement;
        return PsiElement2Declaration.createFromPom(target2, navigationElement);
    }
}

