/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.psi.impl.RangeOverlapException;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00020\fH\u0000\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"RANGE_CONTAINS_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/openapi/util/TextRange;", "Lkotlin/Comparator;", "RANGE_START_COMPARATOR_INVERTED", "chooseByRange", "", "X", "items", "offset", "", "itemRange", "Lkotlin/Function1;", "intellij.platform.lang.impl"})
public final class RangesKt {
    @NotNull
    private static final Comparator<TextRange> RANGE_CONTAINS_COMPARATOR = RangesKt::RANGE_CONTAINS_COMPARATOR$lambda$2;
    @NotNull
    private static final Comparator<TextRange> RANGE_START_COMPARATOR_INVERTED = RangesKt::RANGE_START_COMPARATOR_INVERTED$lambda$3;

    @NotNull
    public static final <X> Collection<X> chooseByRange(@NotNull Collection<? extends X> items2, int offset2, @NotNull Function1<? super X, ? extends TextRange> itemRange) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(itemRange, (String)"itemRange");
        if (items2.size() < 2) {
            return items2;
        }
        SmartList<X> toTheLeftOfOffset = new SmartList<X>();
        SmartList<X> containingOffset = new SmartList<X>();
        for (X item : items2) {
            if (((TextRange)itemRange.invoke(item)).getEndOffset() == offset2) {
                toTheLeftOfOffset.add(item);
                continue;
            }
            containingOffset.add(item);
        }
        if (!((Collection)containingOffset).isEmpty()) {
            Collection collection = containingOffset;
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> RangesKt.chooseByRange$lambda$0(itemRange, arg_0), RANGE_CONTAINS_COMPARATOR);
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(Function(itemR\u2026ANGE_CONTAINS_COMPARATOR)");
            return UtilKt.minimalElements(collection, comparator);
        }
        Collection collection = toTheLeftOfOffset;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> RangesKt.chooseByRange$lambda$1(itemRange, arg_0), RANGE_START_COMPARATOR_INVERTED);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(Function(itemR\u2026TART_COMPARATOR_INVERTED)");
        return UtilKt.minimalElements(collection, comparator);
    }

    private static final TextRange chooseByRange$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TextRange)$tmp0.invoke(p0);
    }

    private static final TextRange chooseByRange$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TextRange)$tmp0.invoke(p0);
    }

    private static final int RANGE_CONTAINS_COMPARATOR$lambda$2(TextRange range1, TextRange range2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)range1, (String)"range1");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range2");
        boolean contains1 = range1.contains(range2);
        boolean contains2 = range2.contains(range1);
        if (contains1 && contains2) {
            n = 0;
        } else if (contains1 && !contains2) {
            n = 1;
        } else if (!contains1 && contains2) {
            n = -1;
        } else {
            throw new RangeOverlapException(range1, range2);
        }
        return n;
    }

    private static final int RANGE_START_COMPARATOR_INVERTED$lambda$3(TextRange range1, TextRange range2) {
        Intrinsics.checkNotNullParameter((Object)range1, (String)"range1");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range2");
        return range2.getStartOffset() - range1.getStartOffset();
    }
}

