/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.ImplicitReferenceProvider;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.psi.impl.ImmediatePsiSymbolReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0007\u00a8\u0006\u0011"}, d2={"allReferencesInElement", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/psi/PsiElement;", "offsetInElement", "", "hasReferencesInElement", "", "startOffsetInElement", "endOffsetInElement", "implicitReference", "referencesInElement", "allReferencesAround", "Lcom/intellij/psi/PsiFile;", "offset", "referencesAt", "intellij.platform.lang.impl"})
public final class ReferencesKt {
    @ApiStatus.Internal
    @NotNull
    public static final Collection<PsiSymbolReference> referencesAt(@NotNull PsiFile $this$referencesAt, int offset2) {
        Intrinsics.checkNotNullParameter((Object)$this$referencesAt, (String)"<this>");
        Iterator<Pair<PsiElement, Integer>> iterator2 = PsiTreeUtilKt.elementsAtOffsetUp($this$referencesAt, offset2);
        while (iterator2.hasNext()) {
            int offsetInElement;
            Pair<PsiElement, Integer> pair = iterator2.next();
            PsiElement element = (PsiElement)pair.component1();
            Collection<PsiSymbolReference> references = ReferencesKt.referencesInElement(element, offsetInElement = ((Number)pair.component2()).intValue());
            if (!(!references.isEmpty())) continue;
            return references;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final Collection<PsiSymbolReference> allReferencesAround(@NotNull PsiFile $this$allReferencesAround, int offset2) {
        Intrinsics.checkNotNullParameter((Object)$this$allReferencesAround, (String)"<this>");
        Iterator<Pair<PsiElement, Integer>> iterator2 = PsiTreeUtilKt.elementsAroundOffsetUp($this$allReferencesAround, offset2);
        while (iterator2.hasNext()) {
            int offsetInElement;
            Pair<PsiElement, Integer> pair = iterator2.next();
            PsiElement element = (PsiElement)pair.component1();
            Collection<PsiSymbolReference> referencesInElement = ReferencesKt.allReferencesInElement(element, offsetInElement = ((Number)pair.component2()).intValue());
            if (!(!referencesInElement.isEmpty())) continue;
            return referencesInElement;
        }
        return CollectionsKt.emptyList();
    }

    public static final boolean hasReferencesInElement(@NotNull PsiElement element, int startOffsetInElement, int endOffsetInElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Collection<PsiSymbolReference> referencesInElement = ReferencesKt.allReferencesInElement(element, -1);
        for (PsiSymbolReference reference2 : referencesInElement) {
            if (!reference2.getRangeInElement().intersects(startOffsetInElement, endOffsetInElement)) continue;
            return true;
        }
        return false;
    }

    private static final Collection<PsiSymbolReference> allReferencesInElement(PsiElement element, int offsetInElement) {
        Collection<PsiSymbolReference> references = ReferencesKt.referencesInElement(element, offsetInElement);
        if (!references.isEmpty()) {
            return references;
        }
        PsiSymbolReference implicitReference = ReferencesKt.implicitReference(element);
        if (implicitReference != null) {
            return CollectionsKt.listOf((Object)implicitReference);
        }
        return CollectionsKt.emptyList();
    }

    private static final Collection<PsiSymbolReference> referencesInElement(PsiElement element, int offsetInElement) {
        if (offsetInElement < 0) {
            Collection<PsiSymbolReference> collection = PsiSymbolReferenceService.getService().getReferences(element);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getService().getReferences(element)");
            return collection;
        }
        PsiSymbolReferenceHints psiSymbolReferenceHints = PsiSymbolReferenceHints.offsetHint(offsetInElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiSymbolReferenceHints, (String)"offsetHint(offsetInElement)");
        PsiSymbolReferenceHints hints = psiSymbolReferenceHints;
        Collection<PsiSymbolReference> collection = PsiSymbolReferenceService.getService().getReferences(element, hints);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getService().getReferences(element, hints)");
        return collection;
    }

    private static final PsiSymbolReference implicitReference(PsiElement element) {
        for (ImplicitReferenceProvider handler2 : ImplicitReferenceProvider.EP_NAME.getExtensions()) {
            Collection<? extends Symbol> resolved;
            Intrinsics.checkNotNullExpressionValue(handler2.resolveAsReference(element), (String)"handler.resolveAsReference(element)");
            if (!(!resolved.isEmpty())) continue;
            return new ImmediatePsiSymbolReference(element, resolved);
        }
        return null;
    }
}

