/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.model.psi.impl.Declarations;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.TextOccurrence;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.util.TextOccurrencesUtilBase;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.codeInsight.CommentUtilCore;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u001a0\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002\u001a\u001e\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u001b0\u001a*\u00020\u0015H\u0002\u00a8\u0006\u001c"}, d2={"buildTextUsageQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/PsiUsage;", "project", "Lcom/intellij/openapi/project/Project;", "searchRequest", "Lcom/intellij/model/search/SearchRequest;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchContexts", "", "Lcom/intellij/model/search/SearchContext;", "hasDeclarationsOrReferences", "", "element", "Lcom/intellij/psi/PsiElement;", "startOffsetInElement", "", "searchStringLength", "isApplicableOccurrence", "occurrence", "Lcom/intellij/model/search/TextOccurrence;", "comments", "strings", "plainText", "walkUp", "", "Lkotlin/Pair;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\ntextSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 textSearch.kt\ncom/intellij/model/search/impl/TextSearchKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class TextSearchKt {
    @NotNull
    public static final Query<? extends PsiUsage> buildTextUsageQuery(@NotNull Project project2, @NotNull SearchRequest searchRequest, @NotNull SearchScope searchScope2, @NotNull Set<? extends SearchContext> searchContexts) {
        Query<Object> query2;
        SearchScope searchScope3;
        int searchStringLength;
        String searchString;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)searchRequest, (String)"searchRequest");
                Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
                Intrinsics.checkNotNullParameter(searchContexts, (String)"searchContexts");
                if (!(!searchContexts.contains(SearchContext.IN_CODE))) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (!(!searchContexts.contains(SearchContext.IN_CODE_HOSTS))) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                if (searchContexts.isEmpty()) {
                    Query query3 = EmptyQuery.getEmptyQuery();
                    Intrinsics.checkNotNullExpressionValue(query3, (String)"getEmptyQuery()");
                    return query3;
                }
                String string4 = searchRequest.getSearchString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"searchRequest.searchString");
                searchString = string4;
                searchStringLength = searchString.length();
                searchScope3 = searchRequest.getSearchScope();
                if (searchScope3 == null) break block8;
                SearchScope p0 = searchScope3;
                boolean bl = false;
                SearchScope searchScope4 = searchScope2.intersectWith(p0);
                searchScope3 = searchScope4;
                if (searchScope4 != null) break block9;
            }
            searchScope3 = searchScope2;
        }
        SearchScope effectiveSearchScope = searchScope3;
        boolean comments = searchContexts.contains(SearchContext.IN_COMMENTS);
        boolean strings2 = searchContexts.contains(SearchContext.IN_STRINGS);
        boolean plainText = searchContexts.contains(SearchContext.IN_PLAIN_TEXT);
        Query query4 = SearchService.getInstance().searchWord(project2, searchString).inContexts(searchContexts).inScope(effectiveSearchScope).buildLeafOccurrenceQuery();
        Intrinsics.checkNotNullExpressionValue((Object)query4, (String)"getInstance()\n    .searc\u2026uildLeafOccurrenceQuery()");
        Query occurrenceQuery = query4;
        if (comments && strings2 && plainText) {
            var12_10 = occurrenceQuery.filtering(arg_0 -> TextSearchKt.buildTextUsageQuery$lambda$0((Function1)new Function1<TextOccurrence, Boolean>(searchStringLength){
                final /* synthetic */ int $searchStringLength;
                {
                    this.$searchStringLength = $searchStringLength;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(TextOccurrence it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return TextSearchKt.access$isApplicableOccurrence(it, this.$searchStringLength);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(var12_10, (String)"searchStringLength = sea\u2026chStringLength)\n    }\n  }");
            query2 = var12_10;
        } else {
            var12_10 = occurrenceQuery.filtering(arg_0 -> TextSearchKt.buildTextUsageQuery$lambda$1((Function1)new Function1<TextOccurrence, Boolean>(searchStringLength, comments, strings2, plainText){
                final /* synthetic */ int $searchStringLength;
                final /* synthetic */ boolean $comments;
                final /* synthetic */ boolean $strings;
                final /* synthetic */ boolean $plainText;
                {
                    this.$searchStringLength = $searchStringLength;
                    this.$comments = $comments;
                    this.$strings = $strings;
                    this.$plainText = $plainText;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(TextOccurrence it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return TextSearchKt.access$isApplicableOccurrence(it, this.$searchStringLength, this.$comments, this.$strings, this.$plainText);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(var12_10, (String)"searchStringLength = sea\u2026ngs, plainText)\n    }\n  }");
            query2 = var12_10;
        }
        Query<Object> filteredOccurrenceQuery2 = query2;
        Query<PsiUsage> query5 = filteredOccurrenceQuery2.mapping(arg_0 -> TextSearchKt.buildTextUsageQuery$lambda$2((Function1)new Function1<TextOccurrence, PsiUsage>(searchStringLength){
            final /* synthetic */ int $searchStringLength;
            {
                this.$searchStringLength = $searchStringLength;
                super(1);
            }

            public final PsiUsage invoke(@NotNull TextOccurrence occurrence) {
                Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
                PsiElement psiElement = occurrence.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"occurrence.element");
                TextRange textRange = TextRange.from(occurrence.getOffsetInElement(), this.$searchStringLength);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(occurrence.offsetIn\u2026ment, searchStringLength)");
                return PsiUsage.Companion.textUsage(psiElement, textRange);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(query5, (String)"searchStringLength = sea\u2026 searchStringLength))\n  }");
        return query5;
    }

    private static final boolean isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength) {
        Iterator<Pair<PsiElement, Integer>> iterator2 = TextSearchKt.walkUp(occurrence);
        while (iterator2.hasNext()) {
            int offsetInElement;
            Pair<PsiElement, Integer> pair = iterator2.next();
            PsiElement element = (PsiElement)pair.component1();
            if (!TextSearchKt.hasDeclarationsOrReferences(element, offsetInElement = ((Number)pair.component2()).intValue(), searchStringLength)) continue;
            return false;
        }
        return true;
    }

    private static final boolean isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength, boolean comments, boolean strings2, boolean plainText) {
        boolean isComment = false;
        boolean isString = false;
        Iterator<Pair<PsiElement, Integer>> iterator2 = TextSearchKt.walkUp(occurrence);
        while (iterator2.hasNext()) {
            int offsetInElement;
            Pair<PsiElement, Integer> pair = iterator2.next();
            PsiElement element = (PsiElement)pair.component1();
            if (TextSearchKt.hasDeclarationsOrReferences(element, offsetInElement = ((Number)pair.component2()).intValue(), searchStringLength)) {
                return false;
            }
            isComment = isComment || CommentUtilCore.isCommentTextElement(element);
            isString = isString || TextOccurrencesUtilBase.isStringLiteralElement(element);
        }
        return comments && isComment || strings2 && isString || plainText && !isComment && !isString;
    }

    private static final Iterator<Pair<PsiElement, Integer>> walkUp(TextOccurrence $this$walkUp) {
        PsiElement psiElement = $this$walkUp.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        return PsiTreeUtilKt.walkUp(psiElement, $this$walkUp.getOffsetInElement());
    }

    private static final boolean hasDeclarationsOrReferences(PsiElement element, int startOffsetInElement, int searchStringLength) {
        int endOffsetInElement = startOffsetInElement + searchStringLength;
        return Declarations.hasDeclarationsInElement(element, startOffsetInElement, endOffsetInElement) || ReferencesKt.hasReferencesInElement(element, startOffsetInElement, endOffsetInElement);
    }

    private static final boolean buildTextUsageQuery$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean buildTextUsageQuery$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PsiUsage buildTextUsageQuery$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiUsage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength) {
        return TextSearchKt.isApplicableOccurrence(occurrence, searchStringLength);
    }

    public static final /* synthetic */ boolean access$isApplicableOccurrence(TextOccurrence occurrence, int searchStringLength, boolean comments, boolean strings2, boolean plainText) {
        return TextSearchKt.isApplicableOccurrence(occurrence, searchStringLength, comments, strings2, plainText);
    }
}

