/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.idea.ActionsBundle;
import com.intellij.moduleDependencies.DependenciesAnalyzeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.NavigatableWithText;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesDependenciesPanel
extends JPanel
implements Disposable {
    public static final String HELP_ID = "module.dependencies.tool.window";
    private static final Comparator<DefaultMutableTreeNode> NODE_COMPARATOR = (o1, o2) -> {
        if (!(o1.getUserObject() instanceof MyUserObject)) {
            return 1;
        }
        if (!(o2.getUserObject() instanceof MyUserObject)) {
            return -1;
        }
        return o1.getUserObject().toString().compareToIgnoreCase(o2.getUserObject().toString());
    };
    private static final ColoredTreeCellRenderer NODE_RENDERER = new ColoredTreeCellRenderer(){

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (tree == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof MyUserObject) {
                MyUserObject node2 = (MyUserObject)userObject;
                this.setIcon(ModuleType.get((Module)node2.myModule).getIcon());
                this.append(node2.myModule.getName(), node2.myInCycle ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else if (userObject != null) {
                @NlsSafe String userObjectString = userObject.toString();
                this.append(userObjectString, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/moduleDependencies/ModulesDependenciesPanel$1", "customizeCellRenderer"));
        }
    };
    private final Project myProject;
    private final Module[] myModules;
    private final DependenciesAnalyzeManager.State myState;
    private final Tree myLeftTree;
    private final Tree myRightTree;
    private final Splitter mySplitter;
    private final JTextComponent myPathField;
    private Content myContent;
    private Graph<Module> myModuleGraph;
    private final Map<Module, Boolean> myCycleMap;

    public ModulesDependenciesPanel(@NotNull Project project2, Module @Nullable [] modules2) {
        if (project2 == null) {
            ModulesDependenciesPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myCycleMap = new HashMap<Module, Boolean>();
        this.myProject = project2;
        this.myModules = modules2 != null ? modules2 : ModuleManager.getInstance(project2).getModules();
        this.myState = DependenciesAnalyzeManager.getInstance(project2).getState();
        this.updateModuleGraph();
        this.myLeftTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Root")));
        this.installLeftTreeListeners();
        ModulesDependenciesPanel.installTreeActions(this.myLeftTree, false);
        this.myRightTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Root")));
        ModulesDependenciesPanel.installTreeActions(this.myRightTree, true);
        this.mySplitter = new Splitter();
        this.mySplitter.setFirstComponent(new MyTreePanel(this.myLeftTree, this.myProject));
        this.mySplitter.setSecondComponent(new MyTreePanel(this.myRightTree, this.myProject));
        this.add((Component)this.mySplitter, "Center");
        this.myPathField = new JTextField();
        this.myPathField.setEditable(false);
        this.add((Component)this.createNorthPanel(), "North");
        project2.getMessageBus().connect(this).subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ModulesDependenciesPanel.this.updateModuleGraph();
                ModulesDependenciesPanel.this.updateSplitterProportion();
                ModulesDependenciesPanel.this.updateLeftTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/moduleDependencies/ModulesDependenciesPanel$2", "rootsChanged"));
            }
        });
        this.updateSplitterProportion();
        this.updateLeftTree();
    }

    private void updateModuleGraph() {
        this.myModuleGraph = ModuleManager.getInstance(this.myProject).moduleGraph(this.myState.includeTests);
        this.myCycleMap.clear();
    }

    private Iterable<Module> getModuleDependencies(Module module2) {
        final Iterator<Module> iterator2 = this.myState.forwardDirection ? this.myModuleGraph.getIn(module2) : this.myModuleGraph.getOut(module2);
        return new Iterable<Module>(){

            @Override
            public Iterator<Module> iterator() {
                return iterator2;
            }
        };
    }

    private boolean isInCycle(Module module2) {
        Boolean inCycle = this.myCycleMap.get(module2);
        if (inCycle == null) {
            Set<List<Module>> cycles = GraphAlgorithms.getInstance().findCycles(this.myModuleGraph, module2);
            inCycle = !cycles.isEmpty();
            this.myCycleMap.put(module2, inCycle);
            for (List<Module> cycle : cycles) {
                for (Module moduleInCycle : cycle) {
                    this.myCycleMap.put(moduleInCycle, true);
                }
            }
        }
        return inCycle;
    }

    private void installLeftTreeListeners() {
        this.myLeftTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode expandedNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                for (int i2 = 0; i2 < expandedNode.getChildCount(); ++i2) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)expandedNode.getChildAt(i2);
                    if (child.getChildCount() != 0 || this.isLooped(event.getPath(), child)) continue;
                    Module module2 = ((MyUserObject)child.getUserObject()).myModule;
                    for (Module dependency : ModulesDependenciesPanel.this.getModuleDependencies(module2)) {
                        child.add(new DefaultMutableTreeNode(new MyUserObject(ModulesDependenciesPanel.this.isInCycle(dependency), dependency)));
                    }
                    TreeUtil.sortRecursively((MutableTreeNode)child, NODE_COMPARATOR);
                }
            }

            private boolean isLooped(TreePath path2, DefaultMutableTreeNode child) {
                for (Object o : path2.getPath()) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)o;
                    if (node2 == child || !Comparing.equal(node2.getUserObject(), child.getUserObject())) continue;
                    return true;
                }
                return false;
            }
        });
        this.myLeftTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = ModulesDependenciesPanel.this.myLeftTree.getSelectionPath();
                if (selectionPath != null) {
                    ModulesDependenciesPanel.this.myPathField.setText(StringUtil.join(selectionPath.getPath(), o -> {
                        Object userObject = ((DefaultMutableTreeNode)o).getUserObject();
                        return userObject instanceof MyUserObject ? ((MyUserObject)userObject).myModule.getName() : "";
                    }, " : "));
                    DefaultMutableTreeNode selection = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    if (selection != null) {
                        ModulesDependenciesPanel.this.updateRightTree(((MyUserObject)selection.getUserObject()).myModule);
                    }
                }
            }
        });
    }

    private static void installTreeActions(Tree tree, boolean enableExpandAll) {
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer((TreeCellRenderer)NODE_RENDERER);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch((JTree)tree, true, o -> o.getLastPathComponent().toString());
        DefaultActionGroup group2 = new DefaultActionGroup();
        CommonActionsManager commonActionManager = CommonActionsManager.getInstance();
        ActionManager globalActionManager = ActionManager.getInstance();
        MyTreeExpander treeExpander = new MyTreeExpander(tree, enableExpandAll);
        group2.add(commonActionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)tree));
        group2.add(commonActionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)tree));
        group2.add(globalActionManager.getAction("EditSource"));
        group2.add((AnAction)Separator.getInstance());
        group2.add(globalActionManager.getAction("ShowPackageDeps"));
        group2.add(globalActionManager.getAction("ShowBackwardPackageDeps"));
        group2.add(globalActionManager.getAction("ShowPackageCycles"));
        group2.add(globalActionManager.getAction("ShowModulesDependencies"));
        PopupHandler.installPopupMenu((JComponent)tree, (ActionGroup)group2, (String)"ModuleDependenciesPopup");
    }

    private void updateSplitterProportion() {
        DFSTBuilder<Module> builder2 = new DFSTBuilder<Module>(this.myModuleGraph);
        this.mySplitter.setProportion(builder2.isAcyclic() ? 1.0f : 0.6f);
    }

    private JComponent createNorthPanel() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add(new AnAction(CommonBundle.messagePointer((String)"action.close", (Object[])new Object[0]), AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                DependenciesAnalyzeManager.getInstance(ModulesDependenciesPanel.this.myProject).closeContent(ModulesDependenciesPanel.this.myContent);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/moduleDependencies/ModulesDependenciesPanel$6", "actionPerformed"));
            }
        });
        final AnAction analyzeDepsAction = ActionManager.getInstance().getAction("ShowPackageDeps");
        group2.add(new AnAction(analyzeDepsAction.getTemplatePresentation().getText(), null, AllIcons.Toolwindows.ToolWindowInspection){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                analyzeDepsAction.actionPerformed(e);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                analyzeDepsAction.update(e);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = analyzeDepsAction.getActionUpdateThread();
                if (actionUpdateThread == null) {
                    7.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/moduleDependencies/ModulesDependenciesPanel$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/moduleDependencies/ModulesDependenciesPanel$7";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        });
        group2.add((AnAction)new ToggleAction(CodeInsightBundle.message("action.module.dependencies.direction", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                return !ModulesDependenciesPanel.this.myState.forwardDirection;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                ModulesDependenciesPanel.this.myState.forwardDirection = !state;
                ModulesDependenciesPanel.this.updateLeftTree();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(2);
                }
                e.getPresentation().setIcon(ModulesDependenciesPanel.this.myState.forwardDirection ? AllIcons.Hierarchy.Subtypes : AllIcons.Hierarchy.Supertypes);
                super.update(e);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    8.$$$reportNull$$$0(3);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/moduleDependencies/ModulesDependenciesPanel$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/moduleDependencies/ModulesDependenciesPanel$8";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 3 -> new IllegalStateException(string2);
                };
            }
        });
        group2.add((AnAction)new ToggleAction(CodeInsightBundle.message("action.module.dependencies.tests", new Object[0]), null, AllIcons.Nodes.TestSourceFolder){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                return ModulesDependenciesPanel.this.myState.includeTests;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    9.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    9.$$$reportNull$$$0(2);
                }
                ModulesDependenciesPanel.this.myState.includeTests = state;
                ModulesDependenciesPanel.this.updateModuleGraph();
                ModulesDependenciesPanel.this.updateLeftTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/moduleDependencies/ModulesDependenciesPanel$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/moduleDependencies/ModulesDependenciesPanel$9";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ModulesDependencies", (ActionGroup)group2, true);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)toolbar.getComponent(), "West");
        panel2.add((Component)this.myPathField, "Center");
        return panel2;
    }

    private void updateLeftTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myLeftTree.getModel().getRoot();
        root.removeAllChildren();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (Module module2 : this.myModules) {
                if (module2.isDisposed()) continue;
                ProgressManager.progress(CodeInsightBundle.message("update.module.tree.progress.text", module2.getName()));
                DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(new MyUserObject(this.isInCycle(module2), module2));
                root.add(moduleNode);
                for (Module dependency : this.getModuleDependencies(module2)) {
                    moduleNode.add(new DefaultMutableTreeNode(new MyUserObject(this.isInCycle(dependency), dependency)));
                }
            }
        }, CodeInsightBundle.message("update.module.tree.progress.title", new Object[0]), true, this.myProject);
        TreeUtil.sortRecursively((MutableTreeNode)root, NODE_COMPARATOR);
        ((DefaultTreeModel)this.myLeftTree.getModel()).reload();
        TreeUtil.promiseSelectFirst((JTree)this.myLeftTree);
    }

    private void updateRightTree(Module module2) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myRightTree.getModel().getRoot();
        root.removeAllChildren();
        Set<List<Module>> cycles = GraphAlgorithms.getInstance().findCycles(this.myModuleGraph, module2);
        int index2 = 1;
        for (List<Module> modules2 : cycles) {
            DefaultMutableTreeNode cycle = new DefaultMutableTreeNode(CodeInsightBundle.message("module.dependencies.cycle.node.text", index2++));
            root.add(cycle);
            cycle.add(new DefaultMutableTreeNode(new MyUserObject(false, module2)));
            for (Module moduleInCycle : modules2) {
                cycle.add(new DefaultMutableTreeNode(new MyUserObject(false, moduleInCycle)));
            }
        }
        ((DefaultTreeModel)this.myRightTree.getModel()).reload();
        TreeUtil.expandAll((JTree)this.myRightTree);
    }

    public void setContent(Content content2) {
        this.myContent = content2;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/moduleDependencies/ModulesDependenciesPanel", "<init>"));
    }

    private static class MyTreePanel
    extends JPanel
    implements DataProvider {
        private final Tree myTree;
        private final Project myProject;

        MyTreePanel(Tree tree, Project project2) {
            super(new BorderLayout());
            this.myTree = tree;
            this.myProject = project2;
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
        }

        public Object getData(@NotNull String dataId) {
            DefaultMutableTreeNode node2;
            Object object;
            TreePath selectionPath;
            if (dataId == null) {
                MyTreePanel.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId) && (selectionPath = this.myTree.getLeadSelectionPath()) != null && (object = selectionPath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (node2 = (DefaultMutableTreeNode)object).getUserObject() instanceof MyUserObject) {
                return ((MyUserObject)node2.getUserObject()).myModule;
            }
            if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
                return ModulesDependenciesPanel.HELP_ID;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && (selectionPath = this.myTree.getLeadSelectionPath()) != null && (object = selectionPath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (node2 = (DefaultMutableTreeNode)object).getUserObject() instanceof MyUserObject) {
                return node2.getUserObject();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/moduleDependencies/ModulesDependenciesPanel$MyTreePanel", "getData"));
        }
    }

    private static class MyTreeExpander
    extends DefaultTreeExpander {
        private final boolean myEnableExpandAll;

        MyTreeExpander(Tree tree, boolean enableExpandAll) {
            super((JTree)tree);
            this.myEnableExpandAll = enableExpandAll;
        }

        public boolean canExpand() {
            return this.myEnableExpandAll && super.canExpand();
        }

        protected void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
            if (tree == null) {
                MyTreeExpander.$$$reportNull$$$0(0);
            }
            super.collapseAll(tree, 3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/moduleDependencies/ModulesDependenciesPanel$MyTreeExpander", "collapseAll"));
        }
    }

    private static class MyUserObject
    implements NavigatableWithText {
        private final Module myModule;
        private final boolean myInCycle;

        MyUserObject(boolean inCycle, Module module2) {
            this.myInCycle = inCycle;
            this.myModule = module2;
        }

        public void navigate(boolean requestFocus) {
            ProjectSettingsService.getInstance(this.myModule.getProject()).openModuleSettings(this.myModule);
        }

        public boolean canNavigate() {
            return !this.myModule.isDisposed();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof MyUserObject && this.myModule.equals(((MyUserObject)o).myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        public String toString() {
            return this.myModule.getName();
        }
    }
}

