/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.moduleDependencies.DependenciesAnalyzeManager;
import com.intellij.moduleDependencies.ModulesDependenciesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class ShowModuleDependenciesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowModuleDependenciesAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowModuleDependenciesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowModuleDependenciesAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        Module[] modules2 = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        if (modules2 == null) {
            Module module2;
            PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_FILE);
            Module module3 = module2 = element != null ? ModuleUtilCore.findModuleForPsiElement(element) : null;
            if (module2 != null && ModuleManager.getInstance(project2).getModules().length > 1) {
                MyModuleOrProjectScope dlg = new MyModuleOrProjectScope(module2.getName());
                if (!dlg.showAndGet()) {
                    return;
                }
                if (!dlg.useProjectScope()) {
                    modules2 = new Module[]{module2};
                }
            }
        }
        ModulesDependenciesPanel panel2 = new ModulesDependenciesPanel(project2, modules2);
        AnalysisScope scope = modules2 != null ? new AnalysisScope(modules2) : new AnalysisScope(project2);
        Content content2 = ContentFactory.getInstance().createContent((JComponent)panel2, scope.getDisplayName(), false);
        content2.setHelpId("module.dependencies.tool.window");
        content2.setDisposer((Disposable)panel2);
        panel2.setContent(content2);
        DependenciesAnalyzeManager.getInstance(project2).addContent(content2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/moduleDependencies/ShowModuleDependenciesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/moduleDependencies/ShowModuleDependenciesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static class MyModuleOrProjectScope
    extends DialogWrapper {
        private final JRadioButton myProjectScope;
        private final JRadioButton myModuleScope;

        protected MyModuleOrProjectScope(String moduleName) {
            super(false);
            this.setTitle(CodeInsightBundle.message("module.dependencies.scope.dialog.title", new Object[0]));
            ButtonGroup group2 = new ButtonGroup();
            this.myProjectScope = new JRadioButton(CodeInsightBundle.message("module.dependencies.scope.dialog.project.button", new Object[0]));
            this.myModuleScope = new JRadioButton(CodeInsightBundle.message("module.dependencies.scope.dialog.module.button", moduleName));
            group2.add(this.myProjectScope);
            group2.add(this.myModuleScope);
            this.myProjectScope.setSelected(true);
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new GridLayout(2, 1));
            panel2.add(this.myProjectScope);
            panel2.add(this.myModuleScope);
            return panel2;
        }

        public boolean useProjectScope() {
            return this.myProjectScope.isSelected();
        }
    }
}

