/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mvstore;

import com.intellij.mvstore.StoreErrorHandler;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"openOrRecreateStore", "Lorg/h2/mvstore/MVStore;", "dbFile", "Ljava/nio/file/Path;", "logSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/diagnostic/Logger;", "openStore", "storeErrorHandler", "Lcom/intellij/mvstore/StoreErrorHandler;", "intellij.platform.util.ex"})
public final class MvstoreKt {
    @NotNull
    public static final MVStore openOrRecreateStore(@NotNull Path dbFile, @NotNull Function0<? extends Logger> logSupplier) {
        MVStore mVStore;
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter(logSupplier, (String)"logSupplier");
        StoreErrorHandler storeErrorHandler = new StoreErrorHandler(dbFile, logSupplier);
        try {
            mVStore = MvstoreKt.openStore(dbFile, storeErrorHandler);
        }
        catch (MVStoreException e) {
            ((Logger)logSupplier.invoke()).warn("Store will be recreated (db=" + dbFile + ")", e);
            Files.deleteIfExists(dbFile);
            mVStore = MvstoreKt.openStore(dbFile, storeErrorHandler);
        }
        return mVStore;
    }

    private static final MVStore openStore(Path dbFile, StoreErrorHandler storeErrorHandler) throws MVStoreException {
        MVStore store = new MVStore.Builder().fileName(((Object)dbFile).toString()).backgroundExceptionHandler((Thread.UncaughtExceptionHandler)storeErrorHandler).autoCommitDisabled().cacheSize(64).open();
        storeErrorHandler.isStoreOpened = true;
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"store");
        return store;
    }
}

