/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.PsiNavigateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoRelatedItem {
    private final @NlsContexts.Separator String myGroup;
    private final int myMnemonic;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    public static final String DEFAULT_GROUP_NAME = "";

    protected GotoRelatedItem(@Nullable PsiElement element, @NlsContexts.Separator String group2, int mnemonic) {
        this.myElementPointer = element == null ? null : SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myGroup = group2;
        this.myMnemonic = mnemonic;
    }

    public GotoRelatedItem(@NotNull PsiElement element, @NlsContexts.Separator String group2) {
        if (element == null) {
            GotoRelatedItem.$$$reportNull$$$0(0);
        }
        this(element, group2, -1);
    }

    public GotoRelatedItem(@NotNull PsiElement element) {
        if (element == null) {
            GotoRelatedItem.$$$reportNull$$$0(1);
        }
        this(element, DEFAULT_GROUP_NAME);
    }

    public void navigate() {
        PsiElement element = this.getElement();
        if (element != null) {
            PsiNavigateUtil.navigate(element);
        }
    }

    @Nullable
    @NlsContexts.ListItem
    public String getCustomName() {
        return null;
    }

    @Nullable
    @Nls
    public String getCustomContainerName() {
        return null;
    }

    @Nullable
    public Icon getCustomIcon() {
        return null;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElementPointer == null ? null : this.myElementPointer.getElement();
    }

    public int getMnemonic() {
        return this.myMnemonic;
    }

    public static List<GotoRelatedItem> createItems(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            GotoRelatedItem.$$$reportNull$$$0(2);
        }
        return GotoRelatedItem.createItems(elements, DEFAULT_GROUP_NAME);
    }

    public static List<GotoRelatedItem> createItems(@NotNull Collection<? extends PsiElement> elements, @NlsContexts.Separator String group2) {
        if (elements == null) {
            GotoRelatedItem.$$$reportNull$$$0(3);
        }
        ArrayList<GotoRelatedItem> items2 = new ArrayList<GotoRelatedItem>(elements.size());
        for (PsiElement psiElement : elements) {
            items2.add(new GotoRelatedItem(psiElement, group2));
        }
        return items2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GotoRelatedItem item = (GotoRelatedItem)o;
        return !(this.myElementPointer != null ? !this.myElementPointer.equals(item.myElementPointer) : item.myElementPointer != null);
    }

    @NlsContexts.Separator
    public String getGroup() {
        return this.myGroup;
    }

    public int hashCode() {
        return this.myElementPointer != null ? this.myElementPointer.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/navigation/GotoRelatedItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

