/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.navigation.JBProtocolRevisionResolver;
import com.intellij.navigation.LocationInFile;
import com.intellij.navigation.NavigatorWithinProject;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ComparatorUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u000278B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u001e\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u00062\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010$\u001a\u00020\u0014H\u0002J\u0014\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aJ\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0006H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0006H\u0002J\u001a\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001b0\u001aH\u0002J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\tH\u0002J3\u00100\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00062!\u00101\u001a\u001d\u0012\u0013\u0012\u001103\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020\u001402H\u0002R'\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00130\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R-\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00069"}, d2={"Lcom/intellij/navigation/NavigatorWithinProject;", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "locationToOffset_", "Lkotlin/Function2;", "Lcom/intellij/navigation/LocationInFile;", "Lcom/intellij/openapi/editor/Editor;", "", "Lcom/intellij/navigation/LocationToOffsetConverter;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lkotlin/jvm/functions/Function2;)V", "locationToOffset", "getLocationToOffset", "()Lkotlin/jvm/functions/Function2;", "navigatorByKeyPrefix", "Lcom/intellij/navigation/NavigatorWithinProject$NavigationKeyPrefix;", "Lkotlin/reflect/KFunction1;", "", "getParameters", "()Ljava/util/Map;", "getProject", "()Lcom/intellij/openapi/project/Project;", "selections", "", "Lkotlin/Pair;", "getSelections", "()Ljava/util/List;", "selections$delegate", "Lkotlin/Lazy;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "absolutePath", "revision", "makeSelectionsVisible", "navigate", "keysPrefixesToNavigate", "navigateByFqn", "reference", "navigateByPath", "pathText", "parseSelections", "performEditorAction", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "locationInFile", "runNavigateTask", "task", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lkotlin/ParameterName;", "name", "indicator", "Companion", "NavigationKeyPrefix", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nNavigatorWithinProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigatorWithinProject.kt\ncom/intellij/navigation/NavigatorWithinProject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1855#2:261\n1855#2,2:269\n1856#2:271\n1855#2,2:273\n1603#2,9:282\n1855#2:291\n1856#2:293\n1612#2:294\n467#3,7:262\n467#3,7:275\n1#4:272\n1#4:292\n*S KotlinDebug\n*F\n+ 1 NavigatorWithinProject.kt\ncom/intellij/navigation/NavigatorWithinProject\n*L\n141#1:261\n142#1:269,2\n141#1:271\n228#1:273,2\n247#1:282,9\n247#1:291\n247#1:293\n247#1:294\n142#1:262,7\n247#1:275,7\n247#1:292\n*E\n"})
public final class NavigatorWithinProject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, String> parameters;
    @NotNull
    private final Function2<LocationInFile, Editor, Integer> locationToOffset;
    @NotNull
    private final Map<NavigationKeyPrefix, KFunction<Unit>> navigatorByKeyPrefix;
    @NotNull
    private final Lazy selections$delegate;
    @NotNull
    private static final String FILE_PROTOCOL = "file://";
    @NotNull
    private static final String PATH_GROUP = "path";
    @NotNull
    private static final String LINE_GROUP = "line";
    @NotNull
    private static final String COLUMN_GROUP = "column";
    @NotNull
    private static final String REVISION = "revision";
    private static final Pattern PATH_WITH_LOCATION = Pattern.compile("(?<path>[^:]+)(:(?<line>[\\d]+))?(:(?<column>[\\d]+))?");

    public NavigatorWithinProject(@NotNull Project project2, @NotNull Map<String, String> parameters2, @NotNull Function2<? super LocationInFile, ? super Editor, Integer> locationToOffset_) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(locationToOffset_, (String)"locationToOffset_");
        this.project = project2;
        this.parameters = parameters2;
        this.locationToOffset = (Function2)new Function2<LocationInFile, Editor, Integer>(locationToOffset_){
            final /* synthetic */ Function2<LocationInFile, Editor, Integer> $locationToOffset_;
            {
                this.$locationToOffset_ = $locationToOffset_;
                super(2);
            }

            @NotNull
            public final Integer invoke(@NotNull LocationInFile locationInFile, @NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)locationInFile, (String)"locationInFile");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Comparable comparable = ComparatorUtil.max((Comparable)this.$locationToOffset_.invoke((Object)locationInFile, (Object)editor2), 0);
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"max(locationToOffset_(locationInFile, editor), 0)");
                return (Integer)comparable;
            }
        };
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)NavigationKeyPrefix.FQN), (Object)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NavigatorWithinProject.access$navigateByFqn((NavigatorWithinProject)this.receiver, p0);
            }
        }), TuplesKt.to((Object)((Object)NavigationKeyPrefix.PATH), (Object)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NavigatorWithinProject.access$navigateByPath((NavigatorWithinProject)this.receiver, p0);
            }
        })};
        this.navigatorByKeyPrefix = MapsKt.mapOf((Pair[])pairArray);
        this.selections$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Pair<? extends LocationInFile, ? extends LocationInFile>>>(this){
            final /* synthetic */ NavigatorWithinProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Pair<LocationInFile, LocationInFile>> invoke() {
                return NavigatorWithinProject.access$parseSelections(this.this$0);
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    @NotNull
    public final Function2<LocationInFile, Editor, Integer> getLocationToOffset() {
        return this.locationToOffset;
    }

    private final List<Pair<LocationInFile, LocationInFile>> getSelections() {
        Lazy lazy = this.selections$delegate;
        return (List)lazy.getValue();
    }

    public final void navigate(@NotNull List<? extends NavigationKeyPrefix> keysPrefixesToNavigate) {
        Intrinsics.checkNotNullParameter(keysPrefixesToNavigate, (String)"keysPrefixesToNavigate");
        Iterable $this$forEach$iv = keysPrefixesToNavigate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NavigationKeyPrefix keyPrefix = (NavigationKeyPrefix)((Object)element$iv);
            boolean bl = false;
            Map<String, String> $this$filterKeys$iv = this.parameters;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it, (String)keyPrefix.getPrefix(), (boolean)false, (int)2, null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Iterable $this$forEach$iv2 = ((Map)result$iv).values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl3 = false;
                KFunction<Unit> kFunction = this.navigatorByKeyPrefix.get((Object)keyPrefix);
                if (kFunction == null) continue;
                ((Function1)kFunction).invoke((Object)it);
            }
        }
    }

    private final void navigateByFqn(String reference2) {
        Object object;
        block3: {
            block2: {
                object = this.parameters.get("__fragment");
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string2 = reference2 + "#" + it;
                object = string2;
                if (string2 != null) break block3;
            }
            object = reference2;
        }
        String fqn = object;
        this.runNavigateTask(reference2, (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(this, fqn){
            final /* synthetic */ NavigatorWithinProject this$0;
            final /* synthetic */ String $fqn;
            {
                this.this$0 = $receiver;
                this.$fqn = $fqn;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DataContext dataContext2 = SimpleDataContext.getProjectContext((Project)this.this$0.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getProjectContext(project)");
                DataContext dataContext3 = dataContext2;
                SymbolSearchEverywhereContributor searcher2 = (SymbolSearchEverywhereContributor)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)new Function0<SymbolSearchEverywhereContributor>(dataContext3){
                    final /* synthetic */ DataContext $dataContext;
                    {
                        this.$dataContext = $dataContext;
                        super(0);
                    }

                    @NotNull
                    public final SymbolSearchEverywhereContributor invoke() {
                        return new SymbolSearchEverywhereContributor(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)this.$dataContext));
                    }
                }, 1, null);
                Disposer.register(this.this$0.getProject(), searcher2);
                try {
                    void $this$forEach$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    List<Item> list2 = searcher2.search(this.$fqn, new EmptyProgressIndicator());
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"searcher.search(fqn, EmptyProgressIndicator())");
                    Iterable iterable = list2;
                    boolean $i$f$filterIsInstance = false;
                    void var6_8 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiElement)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    NavigatorWithinProject navigatorWithinProject = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PsiElement it2 = (PsiElement)element$iv;
                        boolean bl = false;
                        ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(it2, navigatorWithinProject){
                            final /* synthetic */ PsiElement $it;
                            final /* synthetic */ NavigatorWithinProject this$0;
                            {
                                this.$it = $it;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                PsiNavigateUtil.navigate(this.$it);
                                NavigatorWithinProject.access$makeSelectionsVisible(this.this$0);
                            }
                        }, 1, null);
                    }
                }
                finally {
                    Disposer.dispose(searcher2);
                }
            }
        }));
    }

    private final void navigateByPath(String pathText) {
        Triple<String, String, String> triple = Companion.parseNavigationPath(pathText);
        Ref.ObjectRef path2 = new Ref.ObjectRef();
        path2.element = triple.component1();
        String line = (String)triple.component2();
        String column = (String)triple.component3();
        if (path2.element == null) {
            return;
        }
        String string2 = line;
        String string3 = column;
        LocationInFile locationInFile = new LocationInFile(string2 != null ? Integer.parseInt(string2) : 0, string3 != null ? Integer.parseInt(string3) : 0);
        path2.element = FileUtil.expandUserHome((String)path2.element);
        this.runNavigateTask(pathText, (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>((Ref.ObjectRef<String>)path2, this, locationInFile){
            final /* synthetic */ Ref.ObjectRef<String> $path;
            final /* synthetic */ NavigatorWithinProject this$0;
            final /* synthetic */ LocationInFile $locationInFile;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                this.$locationInFile = $locationInFile;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VirtualFile virtualFile2 = null;
                if (FileUtil.isAbsolute((String)this.$path.element)) {
                    VirtualFile virtualFile3 = NavigatorWithinProject.access$findFile(this.this$0, (String)this.$path.element, this.this$0.getParameters().get("revision"));
                    if (virtualFile3 == null) {
                        return;
                    }
                    virtualFile2 = virtualFile3;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object[] objectArray = new String[2];
                    VirtualFile virtualFile4 = ProjectUtil.guessProjectDir((Project)this.this$0.getProject());
                    objectArray[0] = virtualFile4 != null ? virtualFile4.getPath() : null;
                    objectArray[1] = this.this$0.getProject().getBasePath();
                    Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
                    VirtualFile[] virtualFileArray = ProjectRootManager.getInstance(this.this$0.getProject()).getContentRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(project).contentRoots");
                    objectArray = virtualFileArray;
                    Sequence sequence2 = sequence;
                    boolean $i$f$map = false;
                    void var5_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        VirtualFile virtualFile5 = (VirtualFile)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it2.getPath());
                    }
                    VirtualFile virtualFile6 = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv))), (Function1)((Function1)new Function1<String, VirtualFile>(this.this$0, this.$path){
                        final /* synthetic */ NavigatorWithinProject this$0;
                        final /* synthetic */ Ref.ObjectRef<String> $path;
                        {
                            this.this$0 = $receiver;
                            this.$path = $path;
                            super(1);
                        }

                        @Nullable
                        public final VirtualFile invoke(@NotNull String projectPath) {
                            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                            return NavigatorWithinProject.access$findFile(this.this$0, new File(projectPath, (String)this.$path.element).getAbsolutePath(), this.this$0.getParameters().get("revision"));
                        }
                    })));
                    if (virtualFile6 == null) {
                        return;
                    }
                    virtualFile2 = virtualFile6;
                }
                ApplicationManager.getApplication().invokeLater(() -> navigateByPath.1.invoke$lambda$2(this.this$0, virtualFile2, this.$locationInFile));
            }

            /*
             * WARNING - void declaration
             */
            private static final void invoke$lambda$2(NavigatorWithinProject this$0, VirtualFile $virtualFile, LocationInFile $locationInFile) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
                Intrinsics.checkNotNullParameter((Object)$locationInFile, (String)"$locationInFile");
                FileEditor[] fileEditorArray = FileEditorManager.getInstance(this$0.getProject()).openFile($virtualFile, true);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getInstance(project).openFile(virtualFile, true)");
                Object[] $this$filterIsInstance$iv = fileEditorArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof TextEditor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                TextEditor textEditor = (TextEditor)CollectionsKt.first((List)((List)destination$iv$iv));
                boolean bl = false;
                NavigatorWithinProject.access$performEditorAction(this$0, textEditor, $locationInFile);
            }
        }));
    }

    private final void runNavigateTask(String reference2, Function1<? super ProgressIndicator, Unit> task2) {
        Project project2 = this.project;
        Object[] objectArray = new Object[]{reference2};
        String string2 = IdeBundle.message((String)"navigate.command.search.reference.progress.title", (Object[])objectArray);
        ProgressManager.getInstance().run(new Task.Backgroundable(task2, project2, string2){
            final /* synthetic */ Function1<ProgressIndicator, Unit> $task;
            {
                this.$task = $task;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$task.invoke((Object)indicator);
            }

            public boolean shouldStartInBackground() {
                return !ApplicationManager.getApplication().isUnitTestMode();
            }

            public boolean isConditionalModal() {
                return !ApplicationManager.getApplication().isUnitTestMode();
            }
        });
    }

    private final void performEditorAction(TextEditor textEditor, LocationInFile locationInFile) {
        Editor editor2 = textEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"textEditor.editor");
        Editor editor3 = editor2;
        editor3.getCaretModel().removeSecondaryCarets();
        editor3.getCaretModel().moveToOffset(((Number)this.locationToOffset.invoke((Object)locationInFile, (Object)editor3)).intValue());
        editor3.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor3.getSelectionModel().removeSelection();
        IdeFocusManager.getGlobalInstance().requestFocus((Component)editor3.getContentComponent(), true);
        this.makeSelectionsVisible();
    }

    private final void makeSelectionsVisible() {
        Editor editor2 = FileEditorManager.getInstance(this.project).getSelectedTextEditor();
        Iterable $this$forEach$iv = this.getSelections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getSelectionModel()) == null) continue;
            editor3.setSelection(((Number)this.locationToOffset.invoke(it.getFirst(), (Object)editor2)).intValue(), ((Number)this.locationToOffset.invoke(it.getSecond(), (Object)editor2)).intValue());
        }
    }

    private final VirtualFile findFile(String absolutePath, String revision) {
        VirtualFile virtualFile2;
        if (absolutePath == null) {
            return null;
        }
        if (revision != null && (virtualFile2 = JBProtocolRevisionResolver.processResolvers(this.project, absolutePath, revision)) != null) {
            return virtualFile2;
        }
        return VirtualFileManager.getInstance().findFileByUrl(FILE_PROTOCOL + absolutePath);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<LocationInFile, LocationInFile>> parseSelections() {
        void $this$mapNotNullTo$iv$iv;
        Map<String, String> $this$filterKeys$iv = this.parameters;
        boolean $i$f$filterKeys = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"selection", (boolean)false, (int)2, null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$mapNotNull$iv = ((Map)result$iv).values();
        boolean $i$f$mapNotNull = false;
        result$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            char[] cArray = new char[]{'-'};
            List split2 = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (split2.size() != 2) {
                pair = null;
            } else {
                LocationInFile startLocation = NavigatorWithinProject.Companion.parseLocationInFile((String)split2.get(0));
                LocationInFile endLocation = NavigatorWithinProject.Companion.parseLocationInFile((String)split2.get(1));
                pair = startLocation != null && endLocation != null ? new Pair((Object)startLocation, (Object)startLocation) : null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ void access$makeSelectionsVisible(NavigatorWithinProject $this) {
        $this.makeSelectionsVisible();
    }

    public static final /* synthetic */ VirtualFile access$findFile(NavigatorWithinProject $this, String absolutePath, String revision) {
        return $this.findFile(absolutePath, revision);
    }

    public static final /* synthetic */ void access$performEditorAction(NavigatorWithinProject $this, TextEditor textEditor, LocationInFile locationInFile) {
        $this.performEditorAction(textEditor, locationInFile);
    }

    public static final /* synthetic */ void access$navigateByFqn(NavigatorWithinProject $this, String reference2) {
        $this.navigateByFqn(reference2);
    }

    public static final /* synthetic */ void access$navigateByPath(NavigatorWithinProject $this, String pathText) {
        $this.navigateByPath(pathText);
    }

    public static final /* synthetic */ List access$parseSelections(NavigatorWithinProject $this) {
        return $this.parseSelections();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/navigation/NavigatorWithinProject$NavigationKeyPrefix;", "", "prefix", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "toString", "FQN", "PATH", "intellij.platform.lang.impl"})
    public static final class NavigationKeyPrefix
    extends Enum<NavigationKeyPrefix> {
        @NotNull
        private final String prefix;
        public static final /* enum */ NavigationKeyPrefix FQN = new NavigationKeyPrefix("fqn");
        public static final /* enum */ NavigationKeyPrefix PATH = new NavigationKeyPrefix("path");
        private static final /* synthetic */ NavigationKeyPrefix[] $VALUES;

        private NavigationKeyPrefix(String prefix) {
            this.prefix = prefix;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public String toString() {
            return this.prefix;
        }

        public static NavigationKeyPrefix[] values() {
            return (NavigationKeyPrefix[])$VALUES.clone();
        }

        public static NavigationKeyPrefix valueOf(String value) {
            return Enum.valueOf(NavigationKeyPrefix.class, value);
        }

        static {
            $VALUES = navigationKeyPrefixArray = new NavigationKeyPrefix[]{NavigationKeyPrefix.FQN, NavigationKeyPrefix.PATH};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J&\u0010\u000f\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/navigation/NavigatorWithinProject$Companion;", "", "()V", "COLUMN_GROUP", "", "FILE_PROTOCOL", "LINE_GROUP", "PATH_GROUP", "PATH_WITH_LOCATION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REVISION", "parseLocationInFile", "Lcom/intellij/navigation/LocationInFile;", "range", "parseNavigationPath", "Lkotlin/Triple;", "pathText", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Triple<String, String, String> parseNavigationPath(@NotNull String pathText) {
            Intrinsics.checkNotNullParameter((Object)pathText, (String)"pathText");
            Matcher matcher = PATH_WITH_LOCATION.matcher(pathText);
            return !matcher.matches() ? new Triple(null, null, null) : new Triple((Object)matcher.group(NavigatorWithinProject.PATH_GROUP), (Object)matcher.group(NavigatorWithinProject.LINE_GROUP), (Object)matcher.group(NavigatorWithinProject.COLUMN_GROUP));
        }

        private final LocationInFile parseLocationInFile(String range) {
            char[] cArray;
            Object object = new char[]{':'};
            List position = StringsKt.split$default((CharSequence)range, (char[])object, (boolean)false, (int)0, (int)6, null);
            if (position.size() != 2) {
                cArray = null;
            } else {
                try {
                    object = new LocationInFile(Integer.parseInt((String)position.get(0)), Integer.parseInt((String)position.get(1)));
                }
                catch (Exception e) {
                    object = null;
                }
                cArray = object;
            }
            return cArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

