/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.JBProtocolNavigateCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "areOriginsEqual", "", "originUrl", "", "projectOriginUrl", "extractCanonicalPath", "extractHostAndPath", "url", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\noriginSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 originSupport.kt\ncom/intellij/navigation/OriginSupportKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n10#2:57\n*S KotlinDebug\n*F\n+ 1 originSupport.kt\ncom/intellij/navigation/OriginSupportKt\n*L\n10#1:57\n*E\n"})
public final class OriginSupportKt {
    @NotNull
    private static final Logger LOG;

    @VisibleForTesting
    public static final boolean areOriginsEqual(@Nullable String originUrl, @Nullable String projectOriginUrl) {
        CharSequence charSequence = originUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)projectOriginUrl) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String canonicalOrigin = OriginSupportKt.extractCanonicalPath(originUrl);
        String canonicalProjectOrigin = OriginSupportKt.extractCanonicalPath(projectOriginUrl);
        return canonicalOrigin != null && Intrinsics.areEqual((Object)canonicalProjectOrigin, (Object)canonicalOrigin);
    }

    private static final String extractCanonicalPath(String originUrl) {
        CharSequence charSequence = originUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        try {
            String hostAndPath = OriginSupportKt.extractHostAndPath(originUrl);
            String string2 = hostAndPath.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
            return StringsKt.removeSuffix((String)string2, (CharSequence)".git");
        }
        catch (URISyntaxException e) {
            LOG.warn("Malformed origin url '" + originUrl + "' in navigate request", e);
            return null;
        }
    }

    private static final String extractHostAndPath(String url) {
        String path2;
        Object urlWithScheme = URLUtil.containsScheme(url) ? url : "ssh://" + url;
        URI uri = new URI((String)urlWithScheme);
        String host = uri.getHost();
        String string2 = uri.getPath();
        if (string2 == null) {
            string2 = path2 = "";
        }
        if (host != null) {
            String hostPort = uri.getHost() + (String)(uri.getPort() != -1 ? ":" + uri.getPort() : "");
            return hostPort + path2;
        }
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"ssh") && uri.getAuthority() != null) {
            String string3 = uri.getAuthority();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"uri.authority");
            String[] stringArray = new String[]{"@"};
            List at = StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String hostAndOrg = at.size() > 1 ? (String)at.get(1) : (String)at.get(0);
            String[] stringArray2 = new String[]{":"};
            List comma = StringsKt.split$default((CharSequence)hostAndOrg, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String sshPath = comma.size() > 1 ? "/" + comma.get(1) + path2 : path2;
            return comma.get(0) + sshPath;
        }
        return "";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JBProtocolNavigateCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

