/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation.impl;

import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.NavigationService;
import com.intellij.navigation.impl.DirectoryNavigationRequest;
import com.intellij.navigation.impl.RawNavigationRequest;
import com.intellij.navigation.impl.SourceNavigationRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/navigation/impl/NavigationServiceImpl;", "Lcom/intellij/navigation/NavigationService;", "()V", "directoryNavigationRequest", "Lcom/intellij/navigation/NavigationRequest;", "directory", "Lcom/intellij/psi/PsiDirectory;", "rawNavigationRequest", "navigatable", "Lcom/intellij/pom/Navigatable;", "sourceNavigationRequest", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "intellij.platform.lang.impl"})
public final class NavigationServiceImpl
implements NavigationService {
    @Override
    @Nullable
    public NavigationRequest sourceNavigationRequest(@NotNull VirtualFile file2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!file2.isValid()) {
            return null;
        }
        return new SourceNavigationRequest(file2, offset2);
    }

    @Override
    @Nullable
    public NavigationRequest directoryNavigationRequest(@NotNull PsiDirectory directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!directory.isValid()) {
            return null;
        }
        return new DirectoryNavigationRequest(directory);
    }

    @Override
    @Nullable
    public NavigationRequest rawNavigationRequest(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!navigatable.canNavigateToSource() && !navigatable.canNavigate()) {
            return null;
        }
        return new RawNavigationRequest(navigatable);
    }
}

