/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryParameters;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class QueryExecutorBase<Result, Params>
implements QueryExecutor<Result, Params> {
    private final boolean myRequireReadAction;

    protected QueryExecutorBase(boolean requireReadAction) {
        this.myRequireReadAction = requireReadAction;
    }

    protected QueryExecutorBase() {
        this(false);
    }

    @Override
    public final boolean execute(@NotNull Params queryParameters, @NotNull Processor<? super Result> consumer2) {
        if (queryParameters == null) {
            QueryExecutorBase.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            QueryExecutorBase.$$$reportNull$$$0(1);
        }
        AtomicBoolean toContinue = new AtomicBoolean(true);
        Processor<Object> wrapper2 = result2 -> {
            if (!toContinue.get()) {
                return false;
            }
            if (!consumer2.process((Object)result2)) {
                toContinue.set(false);
                return false;
            }
            return true;
        };
        if (this.myRequireReadAction && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            Runnable runnable = () -> {
                if (!(queryParameters instanceof QueryParameters) || ((QueryParameters)queryParameters).isQueryValid()) {
                    this.processQuery(queryParameters, wrapper2);
                }
            };
            if (!DumbService.isDumbAware(this)) {
                Project project2;
                Project project3 = project2 = queryParameters instanceof QueryParameters ? ((QueryParameters)queryParameters).getProject() : null;
                if (project2 != null) {
                    DumbService.getInstance(project2).runReadActionInSmartMode(runnable);
                    return toContinue.get();
                }
            }
            ApplicationManager.getApplication().runReadAction(runnable);
        } else {
            this.processQuery(queryParameters, wrapper2);
        }
        return toContinue.get();
    }

    public abstract void processQuery(@NotNull Params var1, @NotNull Processor<? super Result> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/application/QueryExecutorBase";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

