/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class BulkArrayQueue<T> {
    private int tail;
    private int head;
    private Object[] myQueue = new Object[1024];

    BulkArrayQueue() {
    }

    void enqueue(@NotNull T info2) {
        int newTail;
        if (info2 == null) {
            BulkArrayQueue.$$$reportNull$$$0(0);
        }
        if ((newTail = (this.tail + 1) % this.myQueue.length) == this.head) {
            this.growAndUnwrap(0);
            newTail = this.tail + 1;
        }
        this.myQueue[this.tail] = info2;
        this.tail = newTail;
    }

    private void growAndUnwrap(int reserveAtStart) {
        int firstChunkSize;
        if (reserveAtStart < 0) {
            throw new IllegalArgumentException("illegal argument: " + reserveAtStart);
        }
        int oldCapacity = this.myQueue.length;
        int newCapacity = reserveAtStart + (oldCapacity < 100000 ? oldCapacity * 2 : oldCapacity + (oldCapacity >> 1));
        if (newCapacity <= oldCapacity + reserveAtStart) {
            throw new OutOfMemoryError("reserveAtStart: " + reserveAtStart + "; oldCapacity: " + oldCapacity);
        }
        Object[] newQueue = new Object[newCapacity];
        if (this.head <= this.tail) {
            firstChunkSize = this.tail - this.head;
        } else {
            firstChunkSize = oldCapacity - this.head;
            System.arraycopy(this.myQueue, 0, newQueue, reserveAtStart + firstChunkSize, this.tail);
        }
        System.arraycopy(this.myQueue, this.head, newQueue, reserveAtStart, firstChunkSize);
        this.tail = this.size() + reserveAtStart;
        this.head = reserveAtStart;
        this.myQueue = newQueue;
    }

    int size() {
        return this.head <= this.tail ? this.tail - this.head : this.tail + this.myQueue.length - this.head;
    }

    T pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        int nextHead = (this.head + 1) % this.myQueue.length;
        T info2 = this.getAndNullize(this.head);
        this.head = nextHead;
        return info2;
    }

    @NotNull
    private T getAndNullize(int head) {
        Object t = this.myQueue[head];
        this.myQueue[head] = null;
        Object object = t;
        if (object == null) {
            BulkArrayQueue.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    void bulkEnqueueFirst(@NotNull @NotNull ObjectList<? extends @NotNull T> elements) {
        int oldCapacity;
        int emptySpace;
        int insertSize;
        if (elements == null) {
            BulkArrayQueue.$$$reportNull$$$0(2);
        }
        if ((insertSize = elements.size()) > (emptySpace = (oldCapacity = this.myQueue.length) - this.size() - 1)) {
            this.growAndUnwrap(insertSize);
        }
        int firstChunkSize = this.head <= this.tail ? Math.min(insertSize, this.head) : Math.min(insertSize, this.head - this.tail - 1);
        elements.getElements(0, this.myQueue, this.head - firstChunkSize, firstChunkSize);
        this.head -= firstChunkSize;
        if (firstChunkSize != insertSize) {
            int secondChunkSize = insertSize - firstChunkSize;
            elements.getElements(firstChunkSize, this.myQueue, oldCapacity - secondChunkSize, secondChunkSize);
            this.head = oldCapacity - secondChunkSize;
        }
    }

    void removeAll(@NotNull Predicate<? super T> shouldRemove) {
        if (shouldRemove == null) {
            BulkArrayQueue.$$$reportNull$$$0(3);
        }
        if (this.head <= this.tail) {
            int o = this.head;
            for (int i2 = this.head; i2 < this.tail; ++i2) {
                T info2 = this.getAndNullize(i2);
                if (shouldRemove.test(info2)) continue;
                this.myQueue[o++] = info2;
            }
            this.tail = o;
        } else {
            T info3;
            int i3;
            int o = this.myQueue.length;
            for (i3 = this.myQueue.length - 1; i3 >= this.head; --i3) {
                info3 = this.getAndNullize(i3);
                if (shouldRemove.test(info3)) continue;
                this.myQueue[--o] = info3;
            }
            this.head = o % this.myQueue.length;
            o = 0;
            for (i3 = 0; i3 < this.tail; ++i3) {
                info3 = this.getAndNullize(i3);
                if (shouldRemove.test(info3)) continue;
                this.myQueue[o++] = info3;
            }
            this.tail = o;
        }
    }

    boolean isEmpty() {
        return this.head == this.tail;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/BulkArrayQueue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/BulkArrayQueue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndNullize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bulkEnqueueFirst";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

