/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentCategorizer {
    private ComponentCategorizer() {
    }

    @NotNull
    public static SettingsCategory getCategory(@NotNull PersistentStateComponent<?> component2) {
        if (component2 == null) {
            ComponentCategorizer.$$$reportNull$$$0(0);
        }
        return ComponentCategorizer.getCategory(component2.getClass());
    }

    @NotNull
    public static SettingsCategory getCategory(@NotNull Class<? extends PersistentStateComponent> componentClass) {
        PluginDescriptor plugin;
        if (componentClass == null) {
            ComponentCategorizer.$$$reportNull$$$0(1);
        }
        if ((plugin = PluginManager.getPluginByClass(componentClass)) != null) {
            ComponentCategorizer.getPluginCategory(componentClass, plugin);
        }
        return ComponentCategorizer.getFromAnnotationOrDefault(componentClass, SettingsCategory.OTHER);
    }

    @NotNull
    public static SettingsCategory getPluginCategory(@NotNull Class<? extends PersistentStateComponent> componentClass, @NotNull PluginDescriptor plugin) {
        if (componentClass == null) {
            ComponentCategorizer.$$$reportNull$$$0(2);
        }
        if (plugin == null) {
            ComponentCategorizer.$$$reportNull$$$0(3);
        }
        SettingsCategory settingsCategory = plugin.isBundled() ? ComponentCategorizer.getFromAnnotationOrDefault(componentClass, SettingsCategory.PLUGINS) : SettingsCategory.PLUGINS;
        if (settingsCategory == null) {
            ComponentCategorizer.$$$reportNull$$$0(4);
        }
        return settingsCategory;
    }

    @NotNull
    private static SettingsCategory getFromAnnotationOrDefault(@NotNull Class<? extends PersistentStateComponent> componentClass, @NotNull SettingsCategory defaultCategory) {
        State state;
        if (componentClass == null) {
            ComponentCategorizer.$$$reportNull$$$0(5);
        }
        if (defaultCategory == null) {
            ComponentCategorizer.$$$reportNull$$$0(6);
        }
        SettingsCategory settingsCategory = (state = componentClass.getAnnotation(State.class)) != null && !SettingsCategory.OTHER.equals((Object)state.category()) ? state.category() : defaultCategory;
        if (settingsCategory == null) {
            ComponentCategorizer.$$$reportNull$$$0(7);
        }
        return settingsCategory;
    }

    @Nullable
    public static PluginDescriptor getPlugin(@NotNull PersistentStateComponent<?> component2) {
        if (component2 == null) {
            ComponentCategorizer.$$$reportNull$$$0(8);
        }
        return PluginManager.getPluginByClass(component2.getClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/ComponentCategorizer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/ComponentCategorizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginCategory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromAnnotationOrDefault";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCategory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPluginCategory";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromAnnotationOrDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPlugin";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 7 -> new IllegalStateException(string2);
        };
    }
}

