/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class PathMacroManager
implements PathMacroSubstitutor {
    private PathMacrosImpl myPathMacros;
    private ReplacePathToMacroMap myReplacePathToMacroMap;
    private long myPathMacrosModificationCount;

    @NotNull
    public static PathMacroManager getInstance(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            PathMacroManager.$$$reportNull$$$0(0);
        }
        PathMacroManager pathMacroManager = componentManager.getService(PathMacroManager.class);
        if (pathMacroManager == null) {
            PathMacroManager.$$$reportNull$$$0(1);
        }
        return pathMacroManager;
    }

    public PathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    @NotNull
    public PathMacroFilter getMacroFilter() {
        CompositePathMacroFilter compositePathMacroFilter = Holder.createFilter();
        if (compositePathMacroFilter == null) {
            PathMacroManager.$$$reportNull$$$0(2);
        }
        return compositePathMacroFilter;
    }

    public static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @NotNull String macroName, @SystemIndependent @Nullable String path2) {
        if (result2 == null) {
            PathMacroManager.$$$reportNull$$$0(3);
        }
        if (macroName == null) {
            PathMacroManager.$$$reportNull$$$0(4);
        }
        if (path2 != null) {
            PathMacroManager.doAddFileHierarchyReplacements(result2, Strings.trimEnd(path2, "/"), "$" + macroName + "$");
        }
    }

    private static void doAddFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @NotNull String path2, @NotNull String macro) {
        String parentPath;
        if (result2 == null) {
            PathMacroManager.$$$reportNull$$$0(5);
        }
        if (path2 == null) {
            PathMacroManager.$$$reportNull$$$0(6);
        }
        if (macro == null) {
            PathMacroManager.$$$reportNull$$$0(7);
        }
        if (!(parentPath = PathUtilRt.getParentPath(path2)).isEmpty()) {
            PathMacroManager.doAddFileHierarchyReplacements(result2, parentPath, macro + "/..");
        }
        result2.put(macro, path2);
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result2, String macroName, @Nullable String path2, @Nullable String stopAt) {
        if (path2 == null) {
            return;
        }
        String macro = "$" + macroName + "$";
        path2 = Strings.trimEnd(FileUtilRt.toSystemIndependentName(path2), "/");
        boolean overwrite = true;
        while (Strings.isNotEmpty(path2) && path2.contains("/") && !"/".equals(path2)) {
            result2.addReplacement(path2, macro, overwrite);
            if (path2.equals(stopAt)) break;
            macro = macro + "/..";
            path2 = OSAgnosticPathUtil.getParent(path2);
            overwrite = false;
        }
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result2 = new ExpandMacroToPathMap();
        this.getPathMacros().addMacroExpands(result2);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
        }
        ExpandMacroToPathMap expandMacroToPathMap = result2;
        if (expandMacroToPathMap == null) {
            PathMacroManager.$$$reportNull$$$0(8);
        }
        return expandMacroToPathMap;
    }

    @NotNull
    public final synchronized ReplacePathToMacroMap getReplacePathMap() {
        long pathMacrosModificationCount = this.getPathMacros().getModificationCount();
        if (this.myReplacePathToMacroMap != null && pathMacrosModificationCount == this.myPathMacrosModificationCount) {
            ReplacePathToMacroMap replacePathToMacroMap = this.myReplacePathToMacroMap;
            if (replacePathToMacroMap == null) {
                PathMacroManager.$$$reportNull$$$0(9);
            }
            return replacePathToMacroMap;
        }
        this.myReplacePathToMacroMap = this.computeReplacePathMap();
        this.myPathMacrosModificationCount = pathMacrosModificationCount;
        ReplacePathToMacroMap replacePathToMacroMap = this.myReplacePathToMacroMap;
        if (replacePathToMacroMap == null) {
            PathMacroManager.$$$reportNull$$$0(10);
        }
        return replacePathToMacroMap;
    }

    @NotNull
    protected ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result2 = new ReplacePathToMacroMap();
        this.getPathMacros().addMacroReplacements(result2);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroReplacement((String)entry.getValue(), (String)entry.getKey());
        }
        ReplacePathToMacroMap replacePathToMacroMap = result2;
        if (replacePathToMacroMap == null) {
            PathMacroManager.$$$reportNull$$$0(11);
        }
        return replacePathToMacroMap;
    }

    protected void resetCachedReplacePathMap() {
        this.myReplacePathToMacroMap = null;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    public String expandPath(@Nullable String text2) {
        if (Strings.isEmpty(text2)) {
            return text2;
        }
        return this.getExpandMacroMap().substitute(text2, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Override
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public String collapsePath(@Nullable String text2, boolean recursively) {
        if (Strings.isEmpty(text2)) {
            return text2;
        }
        return this.getReplacePathMap().substitute(text2, SystemInfoRt.isFileSystemCaseSensitive, recursively).toString();
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            PathMacroManager.$$$reportNull$$$0(12);
        }
        this.getExpandMacroMap().substitute(element, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element, boolean recursively) {
        if (element == null) {
            PathMacroManager.$$$reportNull$$$0(13);
        }
        PathMacroManager.collapsePaths(element, recursively, this.getReplacePathMap());
    }

    public static void collapsePaths(@NotNull Element element, boolean recursively, @NotNull ReplacePathToMacroMap map2) {
        if (element == null) {
            PathMacroManager.$$$reportNull$$$0(14);
        }
        if (map2 == null) {
            PathMacroManager.$$$reportNull$$$0(15);
        }
        map2.substitute(element, SystemInfoRt.isFileSystemCaseSensitive, recursively, Holder.createFilter());
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        PathMacrosImpl pathMacrosImpl = this.myPathMacros;
        if (pathMacrosImpl == null) {
            PathMacroManager.$$$reportNull$$$0(16);
        }
        return pathMacrosImpl;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual(FileUtilRt.toSystemIndependentName(path1), FileUtilRt.toSystemIndependentName(path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 9, 10, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/PathMacroManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/PathMacroManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacePathMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeReplacePathMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFileHierarchyReplacements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doAddFileHierarchyReplacements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expandPaths";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collapsePaths";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 8, 9, 10, 11, 16 -> new IllegalStateException(string2);
        };
    }

    private static class Holder {
        private Holder() {
        }

        @NotNull
        private static CompositePathMacroFilter createFilter() {
            return new CompositePathMacroFilter(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList());
        }
    }
}

