/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectWidePathMacroContributor;
import com.intellij.openapi.module.Module;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class ModulePathMacroManager
extends PathMacroManager {
    private final @NotNull Supplier<@Nullable @SystemIndependent String> myProjectFilePathPointer;
    @NotNull
    private final @NotNull Supplier<@NotNull @SystemIndependent String> myModuleDirPointer;

    public ModulePathMacroManager(@NotNull Module module2) {
        if (module2 == null) {
            ModulePathMacroManager.$$$reportNull$$$0(0);
        }
        super(PathMacros.getInstance());
        this.myProjectFilePathPointer = module2.getProject()::getProjectFilePath;
        this.myModuleDirPointer = module2::getModuleFilePath;
    }

    @NonInjectable
    private ModulePathMacroManager(@NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull @NotNull Supplier<@NotNull @SystemIndependent String> moduleDirPointer) {
        if (projectFilePathPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(1);
        }
        if (moduleDirPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(2);
        }
        super(PathMacros.getInstance());
        this.myProjectFilePathPointer = projectFilePathPointer;
        this.myModuleDirPointer = moduleDirPointer;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result2 = super.getExpandMacroMap();
        ModulePathMacroManager.addFileHierarchyReplacements(result2, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.myModuleDirPointer.get()));
        String projectFile = this.myProjectFilePathPointer.get();
        if (projectFile != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result2.addMacroExpand(entry.getKey(), entry.getValue());
            }
        }
        ExpandMacroToPathMap expandMacroToPathMap = result2;
        if (expandMacroToPathMap == null) {
            ModulePathMacroManager.$$$reportNull$$$0(3);
        }
        return expandMacroToPathMap;
    }

    @Override
    @NotNull
    public ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result2 = super.computeReplacePathMap();
        ModulePathMacroManager.addFileHierarchyReplacements(result2, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.myModuleDirPointer.get()), PathMacroUtil.getUserHomePath());
        String projectFile = this.myProjectFilePathPointer.get();
        if (projectFile != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result2.addMacroReplacement(entry.getValue(), entry.getKey());
            }
        }
        ReplacePathToMacroMap replacePathToMacroMap = result2;
        if (replacePathToMacroMap == null) {
            ModulePathMacroManager.$$$reportNull$$$0(4);
        }
        return replacePathToMacroMap;
    }

    public void onImlFileMoved() {
        this.resetCachedReplacePathMap();
    }

    public static ModulePathMacroManager createInstance(@NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull @NotNull Supplier<@NotNull @SystemIndependent String> moduleDirPointer) {
        if (projectFilePathPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(5);
        }
        if (moduleDirPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(6);
        }
        return new ModulePathMacroManager(projectFilePathPointer, moduleDirPointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePathPointer";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirPointer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ModulePathMacroManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ModulePathMacroManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeReplacePathMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

