/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;
import org.jdom.Text;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileStorageCoreUtil {
    private static final Logger LOG = Logger.getInstance(FileStorageCoreUtil.class);
    public static final String COMPONENT = "component";
    public static final String NAME = "name";
    public static final String DEFAULT_EXT = ".xml";

    @NotNull
    public static Map<String, Element> load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        List<Element> children2;
        if (rootElement == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(0);
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        if ((children2 = rootElement.getChildren(COMPONENT)).isEmpty() && rootElement.getName().equals(COMPONENT) && rootElement.getAttributeValue(NAME) != null) {
            children2 = new SmartList<Element>(rootElement);
        }
        CompositePathMacroFilter filter2 = null;
        TreeMap<String, Element> map2 = new TreeMap<String, Element>();
        Iterator<Element> iterator2 = children2.iterator();
        while (iterator2.hasNext()) {
            Element element = iterator2.next();
            String name = FileStorageCoreUtil.getComponentNameIfValid(element);
            if (name == null || element.getAttributes().size() <= 1 && element.getContent().isEmpty()) continue;
            iterator2.remove();
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor && !FileStorageCoreUtil.isKotlinSerializable(element)) {
                if (filter2 == null) {
                    filter2 = new CompositePathMacroFilter(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList());
                }
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element, filter2, PathMacrosImpl.getInstanceEx()));
            }
            element.removeAttribute(NAME);
            map2.put(name, element);
        }
        TreeMap<String, Element> treeMap = map2;
        if (treeMap == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(1);
        }
        return treeMap;
    }

    private static boolean isKotlinSerializable(Element element) {
        if (element.hasAttributes()) {
            return false;
        }
        List<Content> content2 = element.getContent();
        return content2.size() == 1 && content2.get(0) instanceof Text;
    }

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element) {
        String name;
        if (element == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(2);
        }
        if (Strings.isEmpty(name = element.getAttributeValue(NAME))) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement(element));
            return null;
        }
        return name;
    }

    @Nullable
    public static String findComponentName(@NotNull Element element) {
        Parent parent2;
        if (element == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(3);
        }
        Element componentElement = element;
        while ((parent2 = componentElement.getParent()) instanceof Element) {
            componentElement = (Element)parent2;
        }
        return Strings.nullize(componentElement.getAttributeValue(NAME));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentNameIfValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findComponentName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

