/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;

public final class FoldingGroup {
    private static final AtomicLong ourCounter = new AtomicLong();
    @NonNls
    private final String myDebugName;
    private final long myId;

    private FoldingGroup(@NonNls String debugName) {
        this.myDebugName = debugName;
        this.myId = ourCounter.incrementAndGet();
    }

    public static FoldingGroup newGroup(@NonNls String debugName) {
        return new FoldingGroup(debugName);
    }

    @ApiStatus.Internal
    public long getId() {
        return this.myId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoldingGroup group2 = (FoldingGroup)o;
        return this.myId == group2.myId;
    }

    public int hashCode() {
        return (int)(this.myId ^ this.myId >>> 32);
    }

    public String toString() {
        return this.myDebugName;
    }
}

