/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PopupBridge {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final VisualPosition myPosition;
    private AbstractPopup popup;
    private List<Consumer<? super AbstractPopup>> consumers;

    public PopupBridge(@NotNull Editor editor2, @NotNull VisualPosition position) {
        if (editor2 == null) {
            PopupBridge.$$$reportNull$$$0(0);
        }
        if (position == null) {
            PopupBridge.$$$reportNull$$$0(1);
        }
        this.consumers = new ArrayList<Consumer<? super AbstractPopup>>();
        this.myEditor = editor2;
        this.myPosition = position;
    }

    void setPopup(@NotNull AbstractPopup popup2) {
        if (popup2 == null) {
            PopupBridge.$$$reportNull$$$0(2);
        }
        assert (this.popup == null);
        this.popup = popup2;
        this.consumers.forEach(c2 -> c2.accept(popup2));
        this.consumers = null;
    }

    @ApiStatus.Internal
    public void updateLocation() {
        this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, (Object)this.myPosition);
        try {
            this.popup.setLocation(this.popup.getBestPositionFor(this.myEditor));
        }
        finally {
            this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
        }
    }

    @Nullable
    AbstractPopup getPopup() {
        return this.popup;
    }

    public void performWhenAvailable(@NotNull @NotNull Consumer<? super @NotNull AbstractPopup> consumer2) {
        if (consumer2 == null) {
            PopupBridge.$$$reportNull$$$0(3);
        }
        if (this.popup == null) {
            this.consumers.add(consumer2);
        } else {
            consumer2.accept((AbstractPopup)this.popup);
        }
    }

    void performOnCancel(final @NotNull Runnable runnable) {
        if (runnable == null) {
            PopupBridge.$$$reportNull$$$0(4);
        }
        this.performWhenAvailable(popup2 -> popup2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/PopupBridge$1", "onClosed"));
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/PopupBridge";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPopup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performWhenAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performOnCancel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

