/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncrementalFindAction
extends EditorAction {
    public static final Key<Boolean> SEARCH_DISABLED = Key.create("EDITOR_SEARCH_DISABLED");

    public IncrementalFindAction() {
        super((EditorActionHandler)new Handler(false));
    }

    public static class Handler
    extends EditorActionHandler {
        private final boolean myReplace;

        public Handler(boolean isReplace) {
            this.myReplace = isReplace;
        }

        protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            if (!editor2.isOneLineMode()) {
                EditorSearchSession search2 = EditorSearchSession.get(editor2);
                if (search2 != null) {
                    search2.getComponent().requestFocusInTheSearchFieldAndSelectContent(project2);
                    FindUtil.configureFindModel(this.myReplace, editor2, search2.getFindModel(), false);
                } else {
                    FindModel model2;
                    FindManager findManager = FindManager.getInstance((Project)project2);
                    if (this.myReplace) {
                        model2 = findManager.createReplaceInFileModel();
                    } else {
                        model2 = new FindModel();
                        model2.copyFrom(findManager.getFindInFileModel());
                    }
                    boolean consoleViewEditor = ConsoleViewUtil.isConsoleViewEditor((Editor)editor2);
                    FindUtil.configureFindModel(this.myReplace, editor2, model2, consoleViewEditor);
                    EditorSearchSession.start(editor2, model2, project2).getComponent().requestFocusInTheSearchFieldAndSelectContent(project2);
                    if (!consoleViewEditor && editor2.getSelectionModel().hasSelection()) {
                        FindUtil.updateFindInFileModel(project2, model2, true);
                    }
                }
            }
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (this.myReplace && ConsoleViewUtil.isConsoleViewEditor((Editor)editor2) && !ConsoleViewUtil.isReplaceActionEnabledForConsoleViewEditor((Editor)editor2)) {
                return false;
            }
            if (SEARCH_DISABLED.get((UserDataHolder)editor2, false).booleanValue()) {
                return false;
            }
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            return project2 != null && !editor2.isOneLineMode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/IncrementalFindAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

