/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.editorActions.moveUpDown.MoveStatementDownAction;
import com.intellij.codeInsight.editorActions.moveUpDown.MoveStatementUpAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.io.File;

public abstract class MoveStatementUpDownTestBase
extends LightPlatformCodeInsightTestCase {
    private static final String BASE_PATH = "/codeInsight/moveStatementAction/";
    protected Runnable myBeforeMoveTask;
    protected Runnable myAfterMoveTask;

    @Override
    protected void tearDown() throws Exception {
        this.myBeforeMoveTask = null;
        this.myAfterMoveTask = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTest() {
        String baseName = BASE_PATH + this.getTestName(true);
        String ext = this.findExtension();
        String fileName = baseName + "." + ext;
        try {
            String afterFileName = baseName + "_afterUp." + ext;
            EditorActionHandler handler2 = new MoveStatementUpAction().getHandler();
            this.performAction(fileName, handler2, afterFileName);
            afterFileName = baseName + "_afterDown." + ext;
            handler2 = new MoveStatementDownAction().getHandler();
            this.performAction(fileName, handler2, afterFileName);
        }
        finally {
            CodeStyleSettingsManager.getInstance((Project)this.getProject()).dropTemporarySettings();
        }
    }

    private void performAction(String fileName, EditorActionHandler handler2, String afterFileName) {
        this.configureByFile(fileName);
        boolean enabled = handler2.isEnabled(this.getEditor(), null, null);
        File file2 = new File(this.getTestDataPath(), afterFileName);
        if (!file2.exists()) {
            afterFileName = fileName;
        }
        if (this.myBeforeMoveTask != null) {
            this.myBeforeMoveTask.run();
        }
        if (enabled) {
            WriteCommandAction.runWriteCommandAction(null, () -> handler2.execute(this.getEditor(), null, null));
        }
        this.checkResultByFile(afterFileName);
        if (this.myAfterMoveTask != null) {
            this.myAfterMoveTask.run();
        }
    }

    private String findExtension() {
        File[] files2 = new File(this.getTestDataPath() + BASE_PATH).listFiles((dir, name) -> StringUtil.startsWithConcatenation(name, this.getTestName(true), "."));
        return FileTypeManagerEx.getInstanceEx().getExtension(files2[0].getName());
    }
}

