/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.actions.SelectOccurrencesActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectNextOccurrenceAction
extends EditorAction {
    protected SelectNextOccurrenceAction() {
        super((EditorActionHandler)new Handler());
    }

    static class Handler
    extends SelectOccurrencesActionHandler {
        Handler() {
        }

        public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            return editor2.getProject() != null && editor2.getCaretModel().supportsMultipleCarets() && IncrementalFindAction.SEARCH_DISABLED.get((UserDataHolder)editor2, false) == false;
        }

        public void doExecute(@NotNull Editor editor2, @Nullable Caret c2, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            Caret caret = c2 == null ? editor2.getCaretModel().getPrimaryCaret() : c2;
            TextRange wordSelectionRange = Handler.getSelectionRange(editor2, caret);
            boolean notFoundPreviously = Handler.getAndResetNotFoundStatus(editor2);
            boolean wholeWordSearch = Handler.isWholeWordSearch(editor2);
            if (caret.hasSelection()) {
                Project project2 = editor2.getProject();
                String selectedText = caret.getSelectedText();
                if (project2 == null || selectedText == null) {
                    return;
                }
                FindManager findManager = FindManager.getInstance((Project)project2);
                FindModel model2 = Handler.getFindModel(selectedText, wholeWordSearch);
                findManager.setSelectNextOccurrenceWasPerformed();
                findManager.setFindNextModel(model2);
                int searchStartOffset = notFoundPreviously ? 0 : caret.getSelectionEnd();
                FindResult findResult = findManager.findString(editor2.getDocument().getCharsSequence(), searchStartOffset, model2);
                if (findResult.isStringFound()) {
                    boolean caretAdded = FindUtil.selectSearchResultInEditor(editor2, findResult, caret.getOffset() - caret.getSelectionStart());
                    if (!caretAdded && notFoundPreviously) {
                        Handler.setNotFoundStatus(editor2);
                    }
                } else {
                    Handler.setNotFoundStatus(editor2);
                    Handler.showHint(editor2);
                }
            } else {
                if (wordSelectionRange == null) {
                    return;
                }
                Handler.setSelection(editor2, caret, wordSelectionRange);
                Handler.setWholeWordSearch(editor2, true);
            }
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/SelectNextOccurrenceAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

