/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.impl.EditorLastActionTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class SelectOccurrencesActionHandler
extends EditorActionHandler {
    private static final Key<Boolean> NOT_FOUND = Key.create("select.next.occurence.not.found");
    private static final Key<Boolean> WHOLE_WORDS = Key.create("select.next.occurence.whole.words");
    private static final Set<String> SELECT_ACTIONS = ContainerUtil.set("SelectNextOccurrence", "UnselectPreviousOccurrence", "FindNext", "FindPrevious");

    protected static void setSelection(Editor editor2, Caret caret, TextRange selectionRange) {
        EditorActionUtil.makePositionVisible((Editor)editor2, (int)selectionRange.getStartOffset());
        EditorActionUtil.makePositionVisible((Editor)editor2, (int)selectionRange.getEndOffset());
        caret.setSelection(selectionRange.getStartOffset(), selectionRange.getEndOffset());
    }

    protected static void showHint(Editor editor2) {
        String message = FindBundle.message("select.next.occurence.not.found.message", new Object[0]);
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)message));
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)2, 40, 0, false);
    }

    protected static boolean getAndResetNotFoundStatus(Editor editor2) {
        boolean status = editor2.getUserData(NOT_FOUND) != null;
        editor2.putUserData(NOT_FOUND, null);
        return status && SelectOccurrencesActionHandler.isRepeatedActionInvocation();
    }

    protected static void setNotFoundStatus(Editor editor2) {
        editor2.putUserData(NOT_FOUND, (Object)Boolean.TRUE);
    }

    protected static boolean isWholeWordSearch(Editor editor2) {
        Boolean value;
        if (!SelectOccurrencesActionHandler.isRepeatedActionInvocation()) {
            editor2.putUserData(WHOLE_WORDS, null);
        }
        return (value = (Boolean)editor2.getUserData(WHOLE_WORDS)) != null;
    }

    @Nullable
    protected static TextRange getSelectionRange(Editor editor2, Caret caret) {
        return SelectWordUtil.getWordSelectionRange(editor2.getDocument().getCharsSequence(), caret.getOffset(), SelectWordUtil.JAVA_IDENTIFIER_PART_CONDITION);
    }

    protected static void setWholeWordSearch(Editor editor2, boolean isWholeWordSearch) {
        editor2.putUserData(WHOLE_WORDS, (Object)isWholeWordSearch);
    }

    protected static boolean isRepeatedActionInvocation() {
        String lastActionId = EditorLastActionTracker.getInstance().getLastActionId();
        return SELECT_ACTIONS.contains(lastActionId);
    }

    protected static FindModel getFindModel(String text2, boolean wholeWords) {
        FindModel model2 = new FindModel();
        model2.setStringToFind(text2);
        model2.setCaseSensitive(true);
        model2.setWholeWordsOnly(wholeWords);
        return model2;
    }
}

