/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions.lists;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.actions.lists.DefaultListSplitJoinContext;
import com.intellij.openapi.editor.actions.lists.DefaultListSplitJoinContextKt;
import com.intellij.openapi.editor.actions.lists.JoinOrSplit;
import com.intellij.openapi.editor.actions.lists.ListWithElements;
import com.intellij.openapi.editor.actions.lists.TrailingComma;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J2\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J2\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/editor/actions/lists/CommaListSplitJoinContext;", "Lcom/intellij/openapi/editor/actions/lists/DefaultListSplitJoinContext;", "()V", "addOrRemoveTrailingComma", "", "data", "Lcom/intellij/openapi/editor/actions/lists/ListWithElements;", "replacements", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "", "split", "Lcom/intellij/openapi/editor/actions/lists/JoinOrSplit;", "lastElement", "Lcom/intellij/psi/PsiElement;", "addTailReplacementsForJoining", "addTailReplacementsForSplitting", "getJoinText", "getSplitText", "getTrailingComma", "Lcom/intellij/openapi/editor/actions/lists/TrailingComma;", "mode", "isSeparator", "", "element", "intellij.platform.lang.impl"})
public abstract class CommaListSplitJoinContext
extends DefaultListSplitJoinContext {
    @Override
    public boolean isSeparator(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return DefaultListSplitJoinContextKt.isComma(element);
    }

    @Override
    @NotNull
    public String getSplitText(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string2 = CodeInsightBundle.message("intention.name.split.comma.values", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"intention.name.split.comma.values\")");
        return string2;
    }

    @Override
    @NotNull
    public String getJoinText(@NotNull ListWithElements data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string2 = CodeInsightBundle.message("intention.name.join.comma.values", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"intention.name.join.comma.values\")");
        return string2;
    }

    private final void addOrRemoveTrailingComma(ListWithElements data2, List<Pair<TextRange, String>> replacements, JoinOrSplit split2, PsiElement lastElement) {
        PsiElement endElement;
        TrailingComma comma = this.getTrailingComma(data2, split2, lastElement);
        if (comma == TrailingComma.ADD_IF_NOT_EXISTS) {
            if (!this.hasSeparatorAfter(data2, lastElement)) {
                int offset2 = this.findOffsetForBreakAfter(data2, lastElement);
                replacements.add((Pair<TextRange, String>)TuplesKt.to((Object)new TextRange(offset2, offset2), (Object)","));
            }
        } else if (comma == TrailingComma.REMOVE_IF_EXISTS && this.isSeparator(endElement = this.skipAcceptableElements(data2, lastElement))) {
            replacements.add((Pair<TextRange, String>)TuplesKt.to((Object)endElement.getTextRange(), (Object)""));
        }
    }

    @Override
    protected void addTailReplacementsForSplitting(@NotNull ListWithElements data2, @NotNull List<Pair<TextRange, String>> replacements, @NotNull PsiElement lastElement) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        this.addOrRemoveTrailingComma(data2, replacements, JoinOrSplit.SPLIT, lastElement);
        super.addTailReplacementsForSplitting(data2, replacements, lastElement);
    }

    @Override
    protected void addTailReplacementsForJoining(@NotNull ListWithElements data2, @NotNull List<Pair<TextRange, String>> replacements, @NotNull PsiElement lastElement) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        this.addOrRemoveTrailingComma(data2, replacements, JoinOrSplit.JOIN, lastElement);
        super.addTailReplacementsForJoining(data2, replacements, lastElement);
    }

    @NotNull
    protected TrailingComma getTrailingComma(@NotNull ListWithElements data2, @NotNull JoinOrSplit mode, @NotNull PsiElement lastElement) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)lastElement, (String)"lastElement");
        return TrailingComma.IGNORE;
    }
}

