/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions.lists;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.lists.JoinOrSplit;
import com.intellij.openapi.editor.actions.lists.ListSplitJoinContext;
import com.intellij.openapi.editor.actions.lists.ListSplitJoinContextKt;
import com.intellij.openapi.editor.actions.lists.ListWithElements;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H%J0\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J*\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u00130\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J#\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u001b\u001a\u00020\u001cH$J\"\u0010\u001d\u001a\u00020\u00182\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u00130\u0015H\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/editor/actions/lists/SplitJoinIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "extractDocument", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getIntentionText", "", "splitJoinContext", "Lcom/intellij/openapi/editor/actions/lists/ListSplitJoinContext;", "data", "Lcom/intellij/openapi/editor/actions/lists/ListWithElements;", "getListSplitJoinContext", "Lkotlin/Pair;", "getReplacements", "", "Lcom/intellij/openapi/util/TextRange;", "invoke", "", "isAvailable", "", "operation", "Lcom/intellij/openapi/editor/actions/lists/JoinOrSplit;", "validateOrder", "replacements", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nListSplitJoinIntentions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListSplitJoinIntentions.kt\ncom/intellij/openapi/editor/actions/lists/SplitJoinIntention\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n10#2:95\n*S KotlinDebug\n*F\n+ 1 ListSplitJoinIntentions.kt\ncom/intellij/openapi/editor/actions/lists/SplitJoinIntention\n*L\n60#1:95\n*E\n"})
public abstract class SplitJoinIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    @NotNull
    protected abstract JoinOrSplit operation();

    @IntentionName
    @NotNull
    protected abstract String getIntentionText(@NotNull ListSplitJoinContext var1, @NotNull ListWithElements var2);

    @NotNull
    protected abstract List<Pair<TextRange, String>> getReplacements(@NotNull ListSplitJoinContext var1, @NotNull ListWithElements var2);

    @Override
    public final boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Pair<ListSplitJoinContext, ListWithElements> pair = this.getListSplitJoinContext(project2, editor2, element);
        if (pair == null) {
            return false;
        }
        Pair<ListSplitJoinContext, ListWithElements> pair2 = pair;
        ListSplitJoinContext splitJoinContext = (ListSplitJoinContext)pair2.component1();
        ListWithElements data2 = (ListWithElements)pair2.component2();
        this.setText(this.getIntentionText(splitJoinContext, data2));
        return true;
    }

    @Override
    public final void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Pair<ListSplitJoinContext, ListWithElements> pair = this.getListSplitJoinContext(project2, editor2, element);
        if (pair == null) {
            return;
        }
        Pair<ListSplitJoinContext, ListWithElements> pair2 = pair;
        ListSplitJoinContext splitJoinContext = (ListSplitJoinContext)pair2.component1();
        ListWithElements data2 = (ListWithElements)pair2.component2();
        PsiElement list2 = data2.getList();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        Document document = this.extractDocument(project2, editor2, element);
        if (document == null) {
            return;
        }
        Document document2 = document;
        RangeMarker rangeMarker = document2.createRangeMarker(list2.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMarker(list.textRange)");
        RangeMarker marker = rangeMarker;
        PsiFile containingFile = element.getContainingFile();
        List<Pair<TextRange, String>> replacements = this.getReplacements(splitJoinContext, data2);
        for (Pair pair3 : CollectionsKt.reversed((Iterable)replacements)) {
            TextRange range = (TextRange)pair3.component1();
            String text2 = (String)pair3.component2();
            document2.replaceString(range.getStartOffset(), range.getEndOffset(), text2);
        }
        documentManager.commitDocument(document2);
        if (marker.isValid()) {
            Intrinsics.checkNotNullExpressionValue((Object)containingFile, (String)"containingFile");
            TextRange textRange = marker.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"marker.textRange");
            splitJoinContext.reformatRange(containingFile, textRange, this.operation());
        }
    }

    private final Document extractDocument(Project project2, Editor editor2, PsiElement element) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        Object object = editor2;
        if (object == null || (object = object.getDocument()) == null) {
            object = documentManager.getDocument(element.getContainingFile());
        }
        return object;
    }

    protected void validateOrder(@NotNull List<? extends Pair<? extends TextRange, String>> replacements) {
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        TextRange prev = null;
        Iterator<? extends Pair<? extends TextRange, String>> iterator2 = replacements.iterator();
        while (iterator2.hasNext()) {
            TextRange range = (TextRange)iterator2.next().component1();
            if (prev != null && range.getStartOffset() < prev.getEndOffset()) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SplitJoinIntention.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("Incorrect replacements order. The ranges must be sorted");
                break;
            }
            prev = range;
        }
    }

    @Nullable
    protected Pair<ListSplitJoinContext, ListWithElements> getListSplitJoinContext(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ListSplitJoinContextKt.getListSplitJoinContext(element, this.operation());
    }
}

