/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class SegmentArray {
    private static final Logger LOG = Logger.getInstance(SegmentArray.class);
    protected int[] myStarts = new int[64];
    protected int[] myEnds = new int[64];
    protected int mySegmentCount;
    protected static final int INITIAL_SIZE = 64;

    protected SegmentArray() {
    }

    protected void setElementAt(int i2, int startOffset, int endOffset) {
        if (startOffset < 0) {
            LOG.error("Invalid startOffset:" + startOffset);
        }
        if (endOffset < 0) {
            LOG.error("Invalid endOffset:" + endOffset);
        }
        if (i2 >= this.mySegmentCount) {
            this.mySegmentCount = i2 + 1;
        }
        this.myStarts = SegmentArray.reallocateArray(this.myStarts, i2);
        this.myStarts[i2] = startOffset;
        this.myEnds = SegmentArray.reallocateArray(this.myEnds, i2);
        this.myEnds[i2] = endOffset;
    }

    protected void replace(int startOffset, @NotNull SegmentArray data2, int len) {
        if (data2 == null) {
            SegmentArray.$$$reportNull$$$0(0);
        }
        System.arraycopy(data2.myStarts, 0, this.myStarts, startOffset, len);
        System.arraycopy(data2.myEnds, 0, this.myEnds, startOffset, len);
    }

    static int calcCapacity(int currentArraySize, int index2) {
        currentArraySize = currentArraySize == 0 ? 16 : (currentArraySize += currentArraySize / 5);
        if (index2 >= currentArraySize) {
            currentArraySize = index2 + index2 / 5;
        }
        return currentArraySize;
    }

    private static int @NotNull [] reallocateArray(int @NotNull [] array, int index2) {
        if (array == null) {
            SegmentArray.$$$reportNull$$$0(1);
        }
        if (index2 < array.length) {
            if (array == null) {
                SegmentArray.$$$reportNull$$$0(2);
            }
            return array;
        }
        int[] nArray = ArrayUtil.realloc(array, SegmentArray.calcCapacity(array.length, index2));
        if (nArray == null) {
            SegmentArray.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    protected int noSegmentsAvailable(int offset2) {
        throw new IllegalStateException("no segments available. offset = " + offset2);
    }

    protected int offsetOutOfRange(int offset2, int lastValidOffset) {
        throw new IndexOutOfBoundsException("Wrong offset: " + offset2 + ". Should be in range: [0, " + lastValidOffset + "]");
    }

    public final int findSegmentIndex(int offset2) {
        if (this.mySegmentCount <= 0) {
            return offset2 == 0 ? 0 : this.noSegmentsAvailable(offset2);
        }
        int lastValidOffset = this.getLastValidOffset();
        if (offset2 > lastValidOffset || offset2 < 0) {
            return this.offsetOutOfRange(offset2, lastValidOffset);
        }
        int end = this.mySegmentCount - 1;
        if (offset2 == lastValidOffset) {
            return end;
        }
        int start = 0;
        while (start <= end) {
            int i2 = start + end >>> 1;
            if (offset2 < this.myStarts[i2]) {
                end = i2 - 1;
                continue;
            }
            if (offset2 >= this.myEnds[i2]) {
                start = i2 + 1;
                continue;
            }
            return i2;
        }
        return this.segmentNotFound(offset2, start);
    }

    protected int segmentNotFound(int offset2, int start) {
        if (offset2 < this.myStarts[start] || offset2 >= this.myEnds[start]) {
            throw new IllegalStateException("Gap at offset " + offset2 + " near segment " + start);
        }
        return start;
    }

    public int getLastValidOffset() {
        return this.mySegmentCount == 0 ? 0 : this.myEnds[this.mySegmentCount - 1];
    }

    public final void shiftSegments(int startIndex, int shift) {
        for (int i2 = startIndex; i2 < this.mySegmentCount; ++i2) {
            int n = i2;
            this.myStarts[n] = this.myStarts[n] + shift;
            int n2 = i2;
            this.myEnds[n2] = this.myEnds[n2] + shift;
            if (this.myStarts[i2] >= 0 && this.myEnds[i2] >= 0) continue;
            LOG.error("Error shifting segments: myStarts[" + i2 + "] = " + this.myStarts[i2] + ", myEnds[" + i2 + "] = " + this.myEnds[i2]);
        }
    }

    public void removeAll() {
        this.mySegmentCount = 0;
    }

    public void remove(int startIndex, int endIndex) {
        this.myStarts = this.remove(this.myStarts, startIndex, endIndex);
        this.myEnds = this.remove(this.myEnds, startIndex, endIndex);
        this.mySegmentCount -= endIndex - startIndex;
    }

    protected int @NotNull [] remove(int @NotNull [] array, int startIndex, int endIndex) {
        if (array == null) {
            SegmentArray.$$$reportNull$$$0(4);
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            SegmentArray.$$$reportNull$$$0(5);
        }
        return array;
    }

    protected void insert(@NotNull SegmentArray segmentArray, int startIndex) {
        if (segmentArray == null) {
            SegmentArray.$$$reportNull$$$0(6);
        }
        this.myStarts = SegmentArray.insert(this.myStarts, segmentArray.myStarts, startIndex, segmentArray.getSegmentCount(), this.mySegmentCount);
        this.myEnds = SegmentArray.insert(this.myEnds, segmentArray.myEnds, startIndex, segmentArray.getSegmentCount(), this.mySegmentCount);
        this.mySegmentCount += segmentArray.getSegmentCount();
    }

    protected static int @NotNull [] insert(int @NotNull [] array, int @NotNull [] insertArray, int startIndex, int insertLength, int mySegmentCount) {
        if (array == null) {
            SegmentArray.$$$reportNull$$$0(7);
        }
        if (insertArray == null) {
            SegmentArray.$$$reportNull$$$0(8);
        }
        int[] newArray = SegmentArray.reallocateArray(array, mySegmentCount + insertLength);
        if (startIndex < mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            SegmentArray.$$$reportNull$$$0(9);
        }
        return newArray;
    }

    public int getSegmentStart(int index2) {
        if (index2 < 0 || index2 >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index2 + ". Available lines count: " + this.mySegmentCount);
        }
        return this.myStarts[index2];
    }

    public int getSegmentEnd(int index2) {
        if (index2 < 0 || index2 >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong line: " + index2 + ". Available lines count: " + this.mySegmentCount);
        }
        return this.myEnds[index2];
    }

    public int getSegmentCount() {
        return this.mySegmentCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/SegmentArray";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentArray";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/SegmentArray";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

